/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcSINT
extends PlcIECValue<Byte> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    static Byte minValue = -128;
    static Byte maxValue = 127;

    public static PlcSINT of(Object value) {
        if (value instanceof Boolean) {
            return new PlcSINT((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcSINT((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcSINT((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcSINT((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcSINT((Long)value);
        }
        if (value instanceof Float) {
            return new PlcSINT((Float)value);
        }
        if (value instanceof Double) {
            return new PlcSINT((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcSINT((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcSINT((BigDecimal)value);
        }
        return new PlcSINT((String)value);
    }

    public PlcSINT(Boolean value) {
        this.value = value != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        this.isNullable = false;
    }

    public PlcSINT(Byte value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcSINT(Short value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = false;
    }

    public PlcSINT(Integer value) {
        if (value < minValue || value > maxValue) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = false;
    }

    public PlcSINT(Long value) {
        if (value < (long)minValue.byteValue() || value > (long)maxValue.byteValue()) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = false;
    }

    public PlcSINT(Float value) {
        if (value.floatValue() < (float)minValue.byteValue() || value.floatValue() > (float)maxValue.byteValue() || value.floatValue() % 1.0f != 0.0f) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = false;
    }

    public PlcSINT(Double value) {
        if (value < (double)minValue.byteValue() || value > (double)maxValue.byteValue() || value % 1.0 != 0.0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = false;
    }

    public PlcSINT(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(minValue.byteValue())) < 0 || value.compareTo(BigInteger.valueOf(maxValue.byteValue())) > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = true;
    }

    public PlcSINT(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(minValue.byteValue())) < 0 || value.compareTo(BigDecimal.valueOf(maxValue.byteValue())) > 0 || value.scale() > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.byteValue();
        this.isNullable = true;
    }

    public PlcSINT(String value) {
        try {
            this.value = Byte.valueOf(value.trim());
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcSINT(@JsonProperty(value="value") byte value) {
        this.value = value;
        this.isNullable = false;
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && !((Byte)this.value).equals((byte)0);
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return true;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return (Byte)this.value;
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return true;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return ((Byte)this.value).shortValue();
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return ((Byte)this.value).intValue();
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return true;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return ((Byte)this.value).longValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.getLong());
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return true;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return ((Byte)this.value).floatValue();
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return ((Byte)this.value).doubleValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getFloat());
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public String toString() {
        return Byte.toString((Byte)this.value);
    }

    @JsonIgnore
    public byte[] getBytes() {
        byte[] bytes = new byte[]{(byte)((Byte)this.value & 0xFF)};
        return bytes;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws ParseException {
        writeBuffer.writeByte(this.getClass().getSimpleName(), (Byte)this.value, new WithWriterArgs[0]);
    }
}

