/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcULINT
extends PlcIECValue<BigInteger> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    static BigInteger minValue = BigInteger.valueOf(0L);
    static BigInteger maxValue = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L)).add(BigInteger.valueOf(1L));

    public static PlcULINT of(Object value) {
        if (value instanceof Boolean) {
            return new PlcULINT((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcULINT((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcULINT((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcULINT((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcULINT((Long)value);
        }
        if (value instanceof Float) {
            return new PlcULINT((Float)value);
        }
        if (value instanceof Double) {
            return new PlcULINT((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcULINT((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcULINT((BigDecimal)value);
        }
        return new PlcULINT((String)value);
    }

    public PlcULINT(Boolean value) {
        this.value = value != false ? BigInteger.valueOf(1L) : BigInteger.valueOf(0L);
        this.isNullable = false;
    }

    public PlcULINT(Byte value) {
        BigInteger val = BigInteger.valueOf(value.byteValue());
        if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = val;
        this.isNullable = false;
    }

    public PlcULINT(Short value) {
        BigInteger val = BigInteger.valueOf(value.shortValue());
        if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = val;
        this.isNullable = false;
    }

    public PlcULINT(Integer value) {
        BigInteger val = BigInteger.valueOf(value.intValue());
        if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = val;
        this.isNullable = false;
    }

    public PlcULINT(Long value) {
        BigInteger val = BigInteger.valueOf(value);
        if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = val;
        this.isNullable = false;
    }

    public PlcULINT(Float value) {
        try {
            BigInteger val = BigDecimal.valueOf(value.floatValue()).toBigInteger();
            if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
                throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public PlcULINT(Double value) {
        try {
            BigInteger val = BigDecimal.valueOf(value).toBigInteger();
            if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
                throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public PlcULINT(BigInteger value) {
        if (value.compareTo(minValue) < 0 || value.compareTo(maxValue) > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value;
        this.isNullable = false;
    }

    public PlcULINT(BigDecimal value) {
        try {
            BigInteger val = value.toBigInteger();
            if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
                throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public PlcULINT(String value) {
        try {
            BigInteger val = new BigInteger(value.trim());
            if (val.compareTo(minValue) < 0 || val.compareTo(maxValue) > 0) {
                throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
            }
            this.value = val;
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && !((BigInteger)this.value).equals(BigInteger.ZERO);
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(127L)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(-128L)) >= 0;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return ((BigInteger)this.value).byteValue();
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(32767L)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(-32768L)) >= 0;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return ((BigInteger)this.value).shortValue();
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) >= 0;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return ((BigInteger)this.value).intValue();
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return ((BigInteger)this.value).longValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return (BigInteger)this.value;
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return true;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return ((BigInteger)this.value).floatValue();
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return ((BigInteger)this.value).doubleValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return new BigDecimal((BigInteger)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public String toString() {
        return ((BigInteger)this.value).toString();
    }

    @JsonIgnore
    public byte[] getBytes() {
        byte[] tmp = ((BigInteger)this.value).toByteArray();
        byte[] bytes = new byte[8];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = i >= bytes.length - tmp.length ? tmp[i - (bytes.length - tmp.length)] : (byte)0;
        }
        return bytes;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws ParseException {
        writeBuffer.writeBigInteger(this.getClass().getSimpleName(), 64, (BigInteger)this.value, new WithWriterArgs[0]);
    }
}

