/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneratedDriverByteToMessageCodec<T extends Message>
extends ByteToMessageCodec<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratedDriverByteToMessageCodec.class);
    private final boolean bigEndian;
    private final Object[] parserArgs;
    private final MessageIO<T, T> io;

    protected GeneratedDriverByteToMessageCodec(MessageIO<T, T> io, Class<T> clazz, boolean bigEndian, Object[] parserArgs) {
        super(clazz);
        this.io = io;
        this.bigEndian = bigEndian;
        this.parserArgs = parserArgs;
    }

    protected void encode(ChannelHandlerContext ctx, T packet, ByteBuf byteBuf) {
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(packet.getLengthInBytes(), !this.bigEndian);
            this.io.serialize(buffer, packet, new Object[0]);
            byteBuf.writeBytes(buffer.getData());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending bytes to PLC for message {} as data {}", packet, (Object)Hex.encodeHexString((byte[])buffer.getData()));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error encoding package [{}]: {}", new Object[]{packet, e.getMessage(), e});
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) {
        LOGGER.trace("Receiving bytes, trying to decode Message...");
        while (byteBuf.readableBytes() > 0) {
            byte[] bytes = null;
            try {
                int packetSize = this.getPacketSize(byteBuf);
                if (packetSize == -1 || packetSize > byteBuf.readableBytes()) {
                    return;
                }
                bytes = new byte[packetSize];
                byteBuf.readBytes(bytes);
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(bytes, !this.bigEndian);
                Message packet = (Message)this.io.parse(readBuffer, this.parserArgs);
                out.add(packet);
                if (out.size() < 16) continue;
                return;
            }
            catch (Exception e) {
                if (bytes != null) {
                    LOGGER.warn("Error decoding package with content [{}]: {}", new Object[]{Hex.encodeHexString(bytes), e.getMessage(), e});
                }
                this.removeRestOfCorruptPackage(byteBuf);
            }
        }
    }

    protected abstract int getPacketSize(ByteBuf var1);

    protected abstract void removeRestOfCorruptPackage(ByteBuf var1);
}

