/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import com.github.jinahya.bit.io.ArrayByteInput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.io.MyDefaultBitInput;

public class ReadBufferByteBased
implements ReadBuffer {
    private final MyDefaultBitInput bi;
    private final boolean littleEndian;
    private final long totalBytes;

    public ReadBufferByteBased(byte[] input) {
        this(input, false);
    }

    public ReadBufferByteBased(byte[] input, boolean littleEndian) {
        ArrayByteInput abi = new ArrayByteInput(input);
        this.bi = new MyDefaultBitInput(abi);
        this.littleEndian = littleEndian;
        this.totalBytes = input.length;
    }

    @Override
    public int getPos() {
        return (int)this.bi.getPos();
    }

    public byte[] getBytes(int startPos, int endPos) {
        int numBytes = endPos - startPos;
        byte[] data = new byte[numBytes];
        System.arraycopy(((ArrayByteInput)this.bi.getDelegate()).getSource(), startPos, data, 0, numBytes);
        return data;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    @Override
    public boolean hasMore(int numBits) {
        return (long)(numBits / 8) <= this.totalBytes - (long)this.getPos();
    }

    public byte peekByte(int offset) throws ParseException {
        int oldIndex = ((ArrayByteInput)this.bi.getDelegate()).getIndex();
        try {
            ((ArrayByteInput)this.bi.getDelegate()).index(oldIndex + offset);
            byte by = this.bi.readByte(false, 8);
            return by;
        }
        catch (IOException e) {
            throw new ParseException("Error peeking byte", e);
        }
        finally {
            ((ArrayByteInput)this.bi.getDelegate()).index(oldIndex);
        }
    }

    @Override
    public void pullContext(String logicalName, WithReaderArgs ... readerArgs) {
    }

    @Override
    public boolean readBit(String logicalName, WithReaderArgs ... readerArgs) throws ParseException {
        try {
            return this.bi.readBoolean();
        }
        catch (IOException e) {
            throw new ParseException("Error reading bit", e);
        }
    }

    @Override
    public byte readByte(String logicalName, WithReaderArgs ... readerArgs) throws ParseException {
        return this.readSignedByte(logicalName, 8, readerArgs);
    }

    @Override
    public byte[] readByteArray(String logicalName, int numberOfBytes, WithReaderArgs ... readerArgs) throws ParseException {
        byte[] bytes = new byte[numberOfBytes];
        for (int i = 0; i < numberOfBytes; ++i) {
            bytes[i] = this.readByte();
        }
        return bytes;
    }

    @Override
    public byte readUnsignedByte(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned byte must contain at least 1 bit");
        }
        if (bitLength > 7) {
            throw new ParseException("unsigned byte can only contain max 4 bits");
        }
        try {
            return this.bi.readByte(true, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading unsigned byte", e);
        }
    }

    @Override
    public short readUnsignedShort(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned short must contain at least 1 bit");
        }
        if (bitLength > 15) {
            throw new ParseException("unsigned short can only contain max 8 bits");
        }
        try {
            return this.bi.readShort(true, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading unsigned short", e);
        }
    }

    @Override
    public int readUnsignedInt(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned int must contain at least 1 bit");
        }
        if (bitLength > 31) {
            throw new ParseException("unsigned int can only contain max 16 bits");
        }
        try {
            if (this.littleEndian) {
                int intValue = this.bi.readInt(true, bitLength);
                return Integer.reverseBytes(intValue) >>> 16;
            }
            return this.bi.readInt(true, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading unsigned int", e);
        }
    }

    @Override
    public long readUnsignedLong(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned long must contain at least 1 bit");
        }
        if (bitLength > 63) {
            throw new ParseException("unsigned long can only contain max 32 bits");
        }
        try {
            if (this.littleEndian) {
                long longValue = this.bi.readLong(true, bitLength);
                return Long.reverseBytes(longValue) >>> 32;
            }
            return this.bi.readLong(true, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading unsigned long", e);
        }
    }

    @Override
    public BigInteger readUnsignedBigInteger(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned long must contain at least 1 bit");
        }
        if (bitLength > 64) {
            throw new ParseException("unsigned long can only contain max 64 bits");
        }
        try {
            long val = this.bi.readLong(false, bitLength);
            if (this.littleEndian) {
                val = Long.reverseBytes(val);
            }
            if (val >= 0L) {
                return BigInteger.valueOf(val);
            }
            BigInteger constant = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L)).add(BigInteger.valueOf(2L));
            return BigInteger.valueOf(val).add(constant);
        }
        catch (IOException e) {
            throw new ParseException("Error reading unsigned big integer", e);
        }
    }

    @Override
    public byte readSignedByte(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("byte must contain at least 1 bit");
        }
        if (bitLength > 8) {
            throw new ParseException("byte can only contain max 8 bits");
        }
        try {
            return this.bi.readByte(false, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading signed byte", e);
        }
    }

    @Override
    public short readShort(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("short must contain at least 1 bit");
        }
        if (bitLength > 16) {
            throw new ParseException("short can only contain max 16 bits");
        }
        try {
            if (this.littleEndian) {
                return Short.reverseBytes(this.bi.readShort(false, bitLength));
            }
            return this.bi.readShort(false, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading signed short", e);
        }
    }

    @Override
    public int readInt(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("int must contain at least 1 bit");
        }
        if (bitLength > 32) {
            throw new ParseException("int can only contain max 32 bits");
        }
        try {
            if (this.littleEndian) {
                return Integer.reverseBytes(this.bi.readInt(false, bitLength));
            }
            return this.bi.readInt(false, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading signed int", e);
        }
    }

    @Override
    public long readLong(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("long must contain at least 1 bit");
        }
        if (bitLength > 64) {
            throw new ParseException("long can only contain max 64 bits");
        }
        try {
            if (this.littleEndian) {
                return Long.reverseBytes(this.bi.readLong(false, bitLength));
            }
            return this.bi.readLong(false, bitLength);
        }
        catch (IOException e) {
            throw new ParseException("Error reading signed long", e);
        }
    }

    @Override
    public BigInteger readBigInteger(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public float readFloat(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        try {
            if (bitLength == 16) {
                return this.readFloat16();
            }
            if (bitLength == 32) {
                return this.readFloat32(logicalName);
            }
            throw new UnsupportedOperationException("unsupported bit length (only 16 and 32 supported)");
        }
        catch (IOException e) {
            throw new ParseException("Error reading float", e);
        }
    }

    private float readFloat16() throws IOException {
        int signMultiplication;
        boolean sign = this.bi.readBoolean();
        byte exponent = this.bi.readByte(true, 5);
        short fraction = this.bi.readShort(true, 10);
        int n = signMultiplication = sign ? 1 : -1;
        if (exponent >= 1 && exponent <= 30) {
            return (float)(signMultiplication * (2 ^ exponent - 15)) * (1.0f + (float)fraction / 10.0f);
        }
        if (exponent == 0) {
            if (fraction == 0) {
                return 0.0f;
            }
            return (float)(signMultiplication * -16) * ((float)fraction / 10.0f);
        }
        if (exponent == 31) {
            if (fraction == 0) {
                return sign ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
            }
            return Float.NaN;
        }
        throw new NumberFormatException();
    }

    private float readFloat32(String logicalName) throws ParseException {
        int intValue = this.readInt(logicalName, 32, new WithReaderArgs[0]);
        return Float.intBitsToFloat(intValue);
    }

    @Override
    public double readDouble(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        if (bitLength == 64) {
            long longValue = this.readLong(logicalName, 64, new WithReaderArgs[0]);
            return Double.longBitsToDouble(longValue);
        }
        throw new UnsupportedOperationException("Error reading double: unsupported bit length (only 64 supported)");
    }

    @Override
    public BigDecimal readBigDecimal(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public String readString(String logicalName, int bitLength, String encoding, WithReaderArgs ... readerArgs) {
        byte[] strBytes = new byte[bitLength / 8];
        for (int i = 0; i < bitLength / 8 && this.hasMore(8); ++i) {
            try {
                strBytes[i] = this.readByte(logicalName, new WithReaderArgs[0]);
                continue;
            }
            catch (Exception e) {
                throw new PlcRuntimeException((Throwable)e);
            }
        }
        return new String(strBytes, Charset.forName(encoding.replaceAll("[^a-zA-Z0-9]", "")));
    }

    @Override
    public void closeContext(String logicalName, WithReaderArgs ... readerArgs) {
    }
}

