/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.generation.BufferCommons;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;

public class ReadBufferJsonBased
implements ReadBuffer,
BufferCommons {
    public static final String REQUIRED_ELEMENT_NOT_FOUND = "Required element %s not found in %s";
    public static final String REQUIRED_CONTEXT_NOT_FOUND = "Required context %s not found in %s";
    private final Deque stack;
    private final Object rootElement;
    private final boolean doValidateAttr;
    private int pos;

    public ReadBufferJsonBased(InputStream is) {
        this(is, true);
    }

    public ReadBufferJsonBased(InputStream is, boolean doValidateAttr) {
        this.doValidateAttr = doValidateAttr;
        this.pos = 1;
        this.stack = new ArrayDeque();
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.rootElement = mapper.readValue(is, Map.class);
        }
        catch (IOException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    @Override
    public int getPos() {
        return this.pos / 8;
    }

    @Override
    public boolean hasMore(int numBits) {
        return false;
    }

    @Override
    public void pullContext(String logicalName, WithReaderArgs ... readerArgs) {
        logicalName = this.sanitizeLogicalName(logicalName);
        if (this.stack.isEmpty()) {
            if (!(this.rootElement instanceof Map)) {
                throw new PlcRuntimeException(String.format(REQUIRED_CONTEXT_NOT_FOUND, logicalName, this.rootElement));
            }
            Object context = ((Map)this.rootElement).get(logicalName);
            if (context == null) {
                throw new PlcRuntimeException(String.format(REQUIRED_CONTEXT_NOT_FOUND, logicalName, this.rootElement));
            }
            this.stack.push(context);
            return;
        }
        Object peek = this.stack.peek();
        if (peek instanceof List) {
            List contextList = (List)this.stack.pop();
            Object context = contextList.get(0);
            if (contextList.size() < 2) {
                this.stack.push(Collections.emptyList());
            } else {
                contextList.remove(0);
                this.stack.push(contextList);
            }
            Object subContext = ((Map)context).get(logicalName);
            if (subContext == null) {
                throw new PlcRuntimeException(String.format(REQUIRED_CONTEXT_NOT_FOUND, logicalName, peek));
            }
            this.stack.push(subContext);
            return;
        }
        if (!(peek instanceof Map)) {
            throw new PlcRuntimeException("Invalid parser state");
        }
        Map map = (Map)peek;
        Object context = map.get(logicalName);
        if (context == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_CONTEXT_NOT_FOUND, logicalName, peek));
        }
        this.stack.push(context);
    }

    @Override
    public boolean readBit(String logicalName, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(1);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "bit", 1);
        Boolean value = (Boolean)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return value;
    }

    @Override
    public byte readByte(String logicalName, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(8);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "byte", 8);
        String hexString = (String)element.get(logicalName);
        if (hexString == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        if (!hexString.startsWith("0x")) {
            throw new PlcRuntimeException(String.format("Hex string should start with 0x. Actual value %s", hexString));
        }
        hexString = hexString.substring(2);
        return Byte.parseByte(hexString, 16);
    }

    @Override
    public byte[] readByteArray(String logicalName, int numberOfBytes, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(8 * numberOfBytes);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "byte", 8 * numberOfBytes);
        String hexString = (String)element.get(logicalName);
        if (hexString == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        if (!hexString.startsWith("0x")) {
            throw new PlcRuntimeException(String.format("Hex string should start with 0x. Actual value %s", hexString));
        }
        hexString = hexString.substring(2);
        byte[] bytes = new byte[numberOfBytes];
        for (int i = 0; i < hexString.length(); i += 2) {
            bytes[i / 2] = Byte.parseByte(hexString.substring(i, i + 2), 16);
        }
        return bytes;
    }

    @Override
    public byte readUnsignedByte(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "uint", bitLength);
        Integer value = (Integer)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return value.byteValue();
    }

    @Override
    public short readUnsignedShort(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "uint", bitLength);
        Integer value = (Integer)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return value.shortValue();
    }

    @Override
    public int readUnsignedInt(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "uint", bitLength);
        Integer value = (Integer)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return value;
    }

    @Override
    public long readUnsignedLong(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "uint", bitLength);
        Integer value = (Integer)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return value.intValue();
    }

    @Override
    public BigInteger readUnsignedBigInteger(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "uint", bitLength);
        Integer value = (Integer)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return BigInteger.valueOf(value.intValue());
    }

    @Override
    public byte readSignedByte(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "int", bitLength);
        Integer value = (Integer)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return value.byteValue();
    }

    @Override
    public short readShort(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "int", bitLength);
        Integer value = (Integer)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return value.shortValue();
    }

    @Override
    public int readInt(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "int", bitLength);
        Integer value = (Integer)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return value;
    }

    @Override
    public long readLong(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "int", bitLength);
        Integer value = (Integer)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return value.intValue();
    }

    @Override
    public BigInteger readBigInteger(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "int", bitLength);
        Integer value = (Integer)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return BigInteger.valueOf(value.intValue());
    }

    @Override
    public float readFloat(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "float", bitLength);
        Float value = (Float)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return value.floatValue();
    }

    @Override
    public double readDouble(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "float", bitLength);
        Float value = (Float)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return value.floatValue();
    }

    @Override
    public BigDecimal readBigDecimal(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "float", bitLength);
        Float value = (Float)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return BigDecimal.valueOf(value.floatValue());
    }

    @Override
    public String readString(String logicalName, int bitLength, String encoding, WithReaderArgs ... readerArgs) {
        logicalName = this.sanitizeLogicalName(logicalName);
        this.move(bitLength);
        Map element = this.getElement(logicalName);
        this.validateAttr(logicalName, element, "string", bitLength);
        String value = (String)element.get(logicalName);
        if (value == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_ELEMENT_NOT_FOUND, logicalName, this.stack.peek()));
        }
        return value;
    }

    @Override
    public void closeContext(String logicalName, WithReaderArgs ... readerArgs) {
        logicalName = this.sanitizeLogicalName(logicalName);
        if (this.stack.isEmpty()) {
            throw new PlcRuntimeException(String.format("Required context close %s not found in %s", logicalName, this.rootElement));
        }
        this.stack.pop();
        if (this.stack.isEmpty()) {
            return;
        }
        Object peek = this.stack.peek();
        if (peek instanceof List) {
            return;
        }
        if (!(peek instanceof Map)) {
            throw new PlcRuntimeException("Invalid parser state");
        }
        Map map = (Map)peek;
        if (map.get(logicalName) == null) {
            throw new PlcRuntimeException(String.format(REQUIRED_CONTEXT_NOT_FOUND, logicalName, peek));
        }
        map.remove(logicalName);
    }

    private Map getElement(String logicalName) {
        logicalName = this.sanitizeLogicalName(logicalName);
        Object peek = this.stack.peek();
        if (peek instanceof List) {
            List elementList = (List)this.stack.pop();
            Map element = (Map)elementList.get(0);
            if (elementList.size() < 2) {
                this.stack.push(Collections.emptyList());
            } else {
                elementList.remove(0);
                this.stack.push(elementList);
            }
            return element;
        }
        if (peek instanceof Map) {
            return (Map)peek;
        }
        throw new PlcRuntimeException(String.format("Invalid state at %s with %s", logicalName, peek));
    }

    private void validateAttr(String logicalName, Map element, String dataType, int bitLength) {
        if (!this.doValidateAttr) {
            return;
        }
        String renderedKeyDataLengthKey = String.format("%s__plc4x_%s", logicalName, "dataType");
        String actualDataType = (String)element.get(renderedKeyDataLengthKey);
        if (!dataType.equals(actualDataType)) {
            throw new PlcRuntimeException(String.format("Unexpected %s :%s. Want %s", renderedKeyDataLengthKey, actualDataType, dataType));
        }
        String renderedBitLengthKey = String.format("%s__plc4x_%s", logicalName, "bitLength");
        Integer actualBitLength = (Integer)element.get(renderedBitLengthKey);
        if (bitLength != actualBitLength) {
            throw new PlcRuntimeException(String.format("Unexpected %s :%s. Want %s", renderedBitLengthKey, actualBitLength, bitLength));
        }
    }

    private void move(int bits) {
        this.pos += bits;
    }
}

