/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.generation.BufferCommons;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;

public class ReadBufferXmlBased
implements ReadBuffer,
BufferCommons {
    XMLEventReader reader;
    int pos = 1;

    public ReadBufferXmlBased(InputStream is) {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        xmlInputFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        try {
            this.reader = xmlInputFactory.createXMLEventReader(is);
        }
        catch (XMLStreamException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    @Override
    public int getPos() {
        return this.pos / 8;
    }

    @Override
    public boolean hasMore(int numBits) {
        return true;
    }

    @Override
    public void pullContext(String logicalName, WithReaderArgs ... readerArgs) {
        StartElement startElement = this.travelToNextStartElement();
        String elementName = startElement.getName().getLocalPart();
        if (!elementName.equals(logicalName)) {
            throw new PlcRuntimeException(String.format("Unexpected Start element '%s'. Expected '%s'", elementName, logicalName));
        }
    }

    @Override
    public boolean readBit(String logicalName, WithReaderArgs ... readerArgs) throws ParseException {
        String bit = this.decode(logicalName, "bit", 1);
        this.move(1);
        return bit.equals("true");
    }

    @Override
    public byte readByte(String logicalName, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(8);
        String hexString = this.decode(logicalName, "byte", 8);
        if (!hexString.startsWith("0x")) {
            throw new PlcRuntimeException(String.format("Hex string should start with 0x. Actual value %s", hexString));
        }
        hexString = hexString.substring(2);
        return Byte.parseByte(hexString, 16);
    }

    @Override
    public byte[] readByteArray(String logicalName, int numberOfBytes, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(8 * numberOfBytes);
        String hexString = this.decode(logicalName, "byte", 8 * numberOfBytes);
        if (!hexString.startsWith("0x")) {
            throw new PlcRuntimeException(String.format("Hex string should start with 0x. Actual value %s", hexString));
        }
        hexString = hexString.substring(2);
        byte[] bytes = new byte[numberOfBytes];
        for (int i = 0; i < hexString.length(); i += 2) {
            bytes[i / 2] = Byte.parseByte(hexString.substring(i, i + 2), 16);
        }
        return bytes;
    }

    @Override
    public byte readUnsignedByte(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(bitLength);
        return Byte.parseByte(this.decode(logicalName, "uint", bitLength));
    }

    @Override
    public short readUnsignedShort(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(bitLength);
        return Short.parseShort(this.decode(logicalName, "uint", bitLength));
    }

    @Override
    public int readUnsignedInt(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(bitLength);
        return Integer.parseInt(this.decode(logicalName, "uint", bitLength));
    }

    @Override
    public long readUnsignedLong(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(bitLength);
        return Long.parseLong(this.decode(logicalName, "uint", bitLength));
    }

    @Override
    public BigInteger readUnsignedBigInteger(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(bitLength);
        throw new PlcRuntimeException("not implemented yet");
    }

    @Override
    public byte readSignedByte(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(bitLength);
        return Byte.parseByte(this.decode(logicalName, "int", bitLength));
    }

    @Override
    public short readShort(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(bitLength);
        return Short.parseShort(this.decode(logicalName, "int", bitLength));
    }

    @Override
    public int readInt(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(bitLength);
        return Integer.parseInt(this.decode(logicalName, "int", bitLength));
    }

    @Override
    public long readLong(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(bitLength);
        return Long.parseLong(this.decode(logicalName, "int", bitLength));
    }

    @Override
    public BigInteger readBigInteger(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(bitLength);
        return new BigInteger(this.decode(logicalName, "int", bitLength));
    }

    @Override
    public float readFloat(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(bitLength);
        return Float.parseFloat(this.decode(logicalName, "float", bitLength));
    }

    @Override
    public double readDouble(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(bitLength);
        return Double.parseDouble(this.decode(logicalName, "float", bitLength));
    }

    @Override
    public BigDecimal readBigDecimal(String logicalName, int bitLength, WithReaderArgs ... readerArgs) throws ParseException {
        this.move(bitLength);
        return new BigDecimal(this.decode(logicalName, "float", bitLength));
    }

    @Override
    public String readString(String logicalName, int bitLength, String encoding, WithReaderArgs ... readerArgs) {
        this.move(bitLength);
        return this.decode(logicalName, "string", bitLength);
    }

    @Override
    public void closeContext(String logicalName, WithReaderArgs ... readerArgs) {
        EndElement endElement = this.travelToNextEndElement();
        if (!endElement.getName().getLocalPart().equals(logicalName)) {
            throw new PlcRuntimeException(String.format("Unexpected End element '%s'. Expected '%s'", endElement.getName().getLocalPart(), logicalName));
        }
    }

    private void move(int bits) {
        this.pos += bits;
    }

    private StartElement travelToNextStartElement() {
        while (this.reader.hasNext()) {
            XMLEvent xmlEvent;
            try {
                xmlEvent = this.reader.nextEvent();
            }
            catch (XMLStreamException e) {
                throw new PlcRuntimeException((Throwable)e);
            }
            if (xmlEvent.isStartElement()) {
                return xmlEvent.asStartElement();
            }
            if (!xmlEvent.isEndElement()) continue;
            throw new PlcRuntimeException(String.format("Unexpected End element %s", xmlEvent.asEndElement().getName().getLocalPart()));
        }
        throw new PlcRuntimeException("EOF");
    }

    private EndElement travelToNextEndElement() {
        while (this.reader.hasNext()) {
            XMLEvent xmlEvent;
            try {
                xmlEvent = this.reader.nextEvent();
            }
            catch (XMLStreamException e) {
                throw new PlcRuntimeException((Throwable)e);
            }
            if (xmlEvent.isStartElement()) {
                throw new PlcRuntimeException(String.format("Unexpected Start element %s", xmlEvent.asStartElement().getName().getLocalPart()));
            }
            if (!xmlEvent.isEndElement()) continue;
            return xmlEvent.asEndElement();
        }
        throw new PlcRuntimeException("EOF");
    }

    private String decode(String logicalName, String dataType, int bitLength) {
        Characters characters;
        StartElement startElement = this.travelToNextStartElement();
        this.validateStartElement(startElement, logicalName, dataType, bitLength);
        try {
            characters = this.reader.nextEvent().asCharacters();
        }
        catch (XMLStreamException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
        String data = characters.getData();
        try {
            this.reader.nextEvent().asEndElement();
        }
        catch (XMLStreamException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
        return data.trim();
    }

    private void validateStartElement(StartElement startElement, String logicalName, String dataType, int bitLength) {
        logicalName = this.sanitizeLogicalName(logicalName);
        if (!startElement.getName().getLocalPart().equals(logicalName)) {
            throw new PlcRuntimeException(String.format("unexpected element '%s'. Expected '%s'", startElement.getName().getLocalPart(), logicalName));
        }
        this.validateAttr(logicalName, startElement.getAttributes(), dataType, bitLength);
    }

    private void validateAttr(String logicalName, Iterator<Attribute> attr, String dataType, int bitLength) {
        boolean dataTypeValidated = false;
        boolean bitLengthValidate = false;
        while (attr.hasNext()) {
            Attribute attribute = attr.next();
            if (attribute.getName().getLocalPart().equals("dataType")) {
                if (!attribute.getValue().equals(dataType)) {
                    throw new PlcRuntimeException(String.format("%s: Unexpected dataType :%s. Want %s", logicalName, attribute.getValue(), dataType));
                }
                dataTypeValidated = true;
                continue;
            }
            if (!attribute.getName().getLocalPart().equals("bitLength")) continue;
            if (!attribute.getValue().equals(Integer.toString(bitLength))) {
                throw new PlcRuntimeException(String.format("%s: Unexpected bitLength '%s'. Want '%d'", logicalName, attribute.getValue(), bitLength));
            }
            bitLengthValidate = true;
        }
        if (!dataTypeValidated) {
            throw new PlcRuntimeException(String.format("%s: required attribute %s missing", logicalName, "dataType"));
        }
        if (!bitLengthValidate) {
            throw new PlcRuntimeException(String.format("%s: required attribute %s missing", logicalName, "bitLength"));
        }
    }
}

