/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import com.github.jinahya.bit.io.BufferByteOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.io.MyDefaultBitOutput;

public class WriteBufferByteBased
implements WriteBuffer {
    private final ByteBuffer bb;
    private final MyDefaultBitOutput bo;
    private final boolean littleEndian;

    public WriteBufferByteBased(int size) {
        this(size, false);
    }

    public WriteBufferByteBased(int size, boolean littleEndian) {
        this.bb = ByteBuffer.allocate(size);
        BufferByteOutput bbo = new BufferByteOutput(this.bb);
        this.bo = new MyDefaultBitOutput(bbo);
        this.littleEndian = littleEndian;
    }

    public void setPos(int position) {
        this.bb.position(position);
    }

    public byte[] getData() {
        return this.bb.array();
    }

    @Override
    public int getPos() {
        return (int)this.bo.getPos();
    }

    public byte[] getBytes(int startPos, int endPos) {
        int numBytes = endPos - startPos;
        byte[] data = new byte[numBytes];
        System.arraycopy(this.bb.array(), startPos, data, 0, numBytes);
        return data;
    }

    @Override
    public void pushContext(String logicalName, WithWriterArgs ... writerArgs) {
    }

    @Override
    public void writeBit(String logicalName, boolean value, WithWriterArgs ... writerArgs) throws ParseException {
        try {
            this.bo.writeBoolean(value);
        }
        catch (IOException e) {
            throw new ParseException("Error writing bit", e);
        }
    }

    @Override
    public void writeByte(String logicalName, byte value, WithWriterArgs ... writerArgs) throws ParseException {
        this.writeSignedByte(logicalName, 8, value, writerArgs);
    }

    @Override
    public void writeByteArray(String logicalName, byte[] bytes, WithWriterArgs ... writerArgs) throws ParseException {
        for (byte aByte : bytes) {
            this.writeSignedByte(logicalName, 8, aByte, writerArgs);
        }
    }

    @Override
    public void writeUnsignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned byte must contain at least 1 bit");
        }
        if (bitLength > 8) {
            throw new ParseException("unsigned byte can only contain max 8 bits");
        }
        try {
            this.bo.writeByte(true, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error writing unsigned byte", e);
        }
    }

    @Override
    public void writeUnsignedShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned short must contain at least 1 bit");
        }
        if (bitLength > 16) {
            throw new ParseException("unsigned short can only contain max 16 bits");
        }
        try {
            this.bo.writeShort(true, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error writing unsigned short", e);
        }
    }

    @Override
    public void writeUnsignedInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned int must contain at least 1 bit");
        }
        if (bitLength > 32) {
            throw new ParseException("unsigned int can only contain max 32 bits");
        }
        try {
            if (this.littleEndian) {
                value = Integer.reverseBytes(value) >> 16;
            }
            this.bo.writeInt(true, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error writing unsigned int", e);
        }
    }

    @Override
    public void writeUnsignedLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("unsigned long must contain at least 1 bit");
        }
        if (bitLength > 63) {
            throw new ParseException("unsigned long can only contain max 63 bits");
        }
        try {
            if (this.littleEndian) {
                value = Long.reverseBytes(value) >> 32;
            }
            this.bo.writeLong(true, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error writing unsigned long", e);
        }
    }

    @Override
    public void writeUnsignedBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws ParseException {
        block10: {
            try {
                if (bitLength == 64) {
                    if (this.littleEndian) {
                        if (value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0) {
                            this.writeLong(logicalName, 32, value.longValue(), new WithWriterArgs[0]);
                            this.writeLong(logicalName, 32, value.shiftRight(32).longValue(), new WithWriterArgs[0]);
                        } else {
                            this.writeLong(logicalName, bitLength, value.longValue(), new WithWriterArgs[0]);
                        }
                    } else if (value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0) {
                        this.writeLong(logicalName, 32, value.shiftRight(32).longValue(), new WithWriterArgs[0]);
                        this.writeLong(logicalName, 32, value.longValue(), new WithWriterArgs[0]);
                    } else {
                        this.writeLong(logicalName, bitLength, value.longValue(), new WithWriterArgs[0]);
                    }
                    break block10;
                }
                if (bitLength < 64) {
                    this.writeUnsignedLong(logicalName, bitLength, value.longValue(), new WithWriterArgs[0]);
                    break block10;
                }
                throw new ParseException("Unsigned Big Integer can only contain max 64 bits");
            }
            catch (ArithmeticException e) {
                throw new ParseException("Error writing unsigned big integer", e);
            }
        }
    }

    @Override
    public void writeSignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("byte must contain at least 1 bit");
        }
        if (bitLength > 8) {
            throw new ParseException("byte can only contain max 8 bits");
        }
        try {
            this.bo.writeByte(false, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error writing signed byte", e);
        }
    }

    @Override
    public void writeShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("short must contain at least 1 bit");
        }
        if (bitLength > 16) {
            throw new ParseException("short can only contain max 16 bits");
        }
        try {
            if (this.littleEndian) {
                value = Short.reverseBytes(value);
            }
            this.bo.writeShort(false, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error writing signed short", e);
        }
    }

    @Override
    public void writeInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("int must contain at least 1 bit");
        }
        if (bitLength > 32) {
            throw new ParseException("int can only contain max 32 bits");
        }
        try {
            if (this.littleEndian) {
                value = Integer.reverseBytes(value);
            }
            this.bo.writeInt(false, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error writing signed int", e);
        }
    }

    @Override
    public void writeLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws ParseException {
        if (bitLength <= 0) {
            throw new ParseException("long must contain at least 1 bit");
        }
        if (bitLength > 64) {
            throw new ParseException("long can only contain max 64 bits");
        }
        try {
            if (this.littleEndian) {
                value = Long.reverseBytes(value);
            }
            this.bo.writeLong(false, bitLength, value);
        }
        catch (IOException e) {
            throw new ParseException("Error writing signed long", e);
        }
    }

    @Override
    public void writeBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws ParseException {
        try {
            if (bitLength > 64) {
                throw new ParseException("Big Integer can only contain max 64 bits");
            }
            this.writeLong(logicalName, bitLength, value.longValue(), new WithWriterArgs[0]);
        }
        catch (ArithmeticException e) {
            throw new ParseException("Error writing big integer", e);
        }
    }

    @Override
    public void writeFloat(String logicalName, float value, int bitsExponent, int bitsMantissa, WithWriterArgs ... writerArgs) throws ParseException {
        if (bitsExponent != 8 || bitsMantissa != 23) {
            throw new UnsupportedOperationException("Error writing float: Exponent and/or Mantissa non standard size");
        }
        this.writeInt(logicalName, 1 + bitsExponent + bitsMantissa, Float.floatToRawIntBits(value), new WithWriterArgs[0]);
    }

    @Override
    public void writeDouble(String logicalName, double value, int bitsExponent, int bitsMantissa, WithWriterArgs ... writerArgs) throws ParseException {
        if (bitsExponent != 11 || bitsMantissa != 52) {
            throw new UnsupportedOperationException("Error writing double: Exponent and/or Mantissa non standard size");
        }
        this.writeLong(logicalName, 1 + bitsExponent + bitsMantissa, Double.doubleToRawLongBits(value), new WithWriterArgs[0]);
    }

    @Override
    public void writeBigDecimal(String logicalName, int bitLength, BigDecimal value, WithWriterArgs ... writerArgs) throws ParseException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void writeString(String logicalName, int bitLength, String encoding, String value, WithWriterArgs ... writerArgs) throws ParseException {
        byte[] bytes = value.getBytes(Charset.forName(encoding.replaceAll("[^a-zA-Z0-9]", "")));
        int fixedByteLength = bitLength / 8;
        if (bitLength == 0) {
            fixedByteLength = bytes.length;
        }
        try {
            for (int i = 0; i < fixedByteLength; ++i) {
                if (i >= bytes.length) {
                    this.bo.writeByte(false, 8, (byte)0);
                    continue;
                }
                this.bo.writeByte(false, 8, bytes[i]);
            }
        }
        catch (IOException e) {
            throw new ParseException("Error writing string", e);
        }
    }

    @Override
    public void popContext(String logicalName, WithWriterArgs ... writerArgs) {
    }
}

