/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.generation;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.generation.BufferCommons;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class WriteBufferXmlBased
implements WriteBuffer,
BufferCommons {
    Deque<String> stack;
    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    XMLEventFactory xmlEventFactory;
    XMLEventWriter xmlEventWriter;
    int pos = 1;
    int depth = 0;

    public WriteBufferXmlBased() {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        this.xmlEventFactory = XMLEventFactory.newInstance();
        try {
            this.xmlEventWriter = xmlOutputFactory.createXMLEventWriter(this.byteArrayOutputStream);
        }
        catch (XMLStreamException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
        this.stack = new ArrayDeque<String>();
    }

    @Override
    public int getPos() {
        return this.pos / 8;
    }

    @Override
    public void pushContext(String logicalName, WithWriterArgs ... writerArgs) {
        try {
            this.indent();
            ++this.depth;
            StartElement startElement = this.xmlEventFactory.createStartElement("", "", logicalName);
            this.xmlEventWriter.add(startElement);
            if (this.isToBeRenderedAsList(writerArgs)) {
                Attribute isListAttribute = this.xmlEventFactory.createAttribute("isList", "true");
                this.xmlEventWriter.add(isListAttribute);
            }
            this.newLine();
        }
        catch (XMLStreamException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
        this.stack.push(logicalName);
    }

    @Override
    public void writeBit(String logicalName, boolean value, WithWriterArgs ... writerArgs) throws ParseException {
        String dataType = "bit";
        int bitLength = 1;
        String data = Boolean.toString(value);
        this.createAndAppend(logicalName, dataType, bitLength, data, writerArgs);
        this.move(1);
    }

    @Override
    public void writeByte(String logicalName, byte value, WithWriterArgs ... writerArgs) throws ParseException {
        this.createAndAppend(logicalName, "byte", 8, String.format("0x%02x", value), writerArgs);
        this.move(8);
    }

    @Override
    public void writeByteArray(String logicalName, byte[] bytes, WithWriterArgs ... writerArgs) throws ParseException {
        StringBuilder hexString = new StringBuilder("0x");
        for (byte aByte : bytes) {
            hexString.append(String.format("%02x", aByte));
        }
        this.createAndAppend(logicalName, "byte", bytes.length * 8, hexString.toString(), writerArgs);
        this.move(8 * bytes.length);
    }

    @Override
    public void writeUnsignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws ParseException {
        this.createAndAppend(logicalName, "uint", bitLength, Byte.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws ParseException {
        this.createAndAppend(logicalName, "uint", bitLength, Short.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws ParseException {
        this.createAndAppend(logicalName, "uint", bitLength, Integer.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws ParseException {
        this.createAndAppend(logicalName, "uint", bitLength, Long.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeUnsignedBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws ParseException {
        this.createAndAppend(logicalName, "uint", bitLength, value.toString(), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeSignedByte(String logicalName, int bitLength, byte value, WithWriterArgs ... writerArgs) throws ParseException {
        this.createAndAppend(logicalName, "int", bitLength, Byte.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeShort(String logicalName, int bitLength, short value, WithWriterArgs ... writerArgs) throws ParseException {
        this.createAndAppend(logicalName, "int", bitLength, Short.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeInt(String logicalName, int bitLength, int value, WithWriterArgs ... writerArgs) throws ParseException {
        this.createAndAppend(logicalName, "int", bitLength, Integer.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeLong(String logicalName, int bitLength, long value, WithWriterArgs ... writerArgs) throws ParseException {
        this.createAndAppend(logicalName, "int", bitLength, Long.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeBigInteger(String logicalName, int bitLength, BigInteger value, WithWriterArgs ... writerArgs) throws ParseException {
        this.createAndAppend(logicalName, "int", bitLength, value.toString(), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeFloat(String logicalName, float value, int bitsExponent, int bitsMantissa, WithWriterArgs ... writerArgs) throws ParseException {
        int bitLength = (value < 0.0f ? 1 : 0) + bitsExponent + bitsMantissa;
        this.createAndAppend(logicalName, "float", bitLength, Float.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeDouble(String logicalName, double value, int bitsExponent, int bitsMantissa, WithWriterArgs ... writerArgs) throws ParseException {
        int bitLength = (value < 0.0 ? 1 : 0) + bitsExponent + bitsMantissa;
        this.createAndAppend(logicalName, "float", bitLength, Double.toString(value), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeBigDecimal(String logicalName, int bitLength, BigDecimal value, WithWriterArgs ... writerArgs) throws ParseException {
        this.createAndAppend(logicalName, "float", bitLength, value.toString(), writerArgs);
        this.move(bitLength);
    }

    @Override
    public void writeString(String logicalName, int bitLength, String encoding, String value, WithWriterArgs ... writerArgs) throws ParseException {
        this.createAndAppend(logicalName, "string", bitLength, value, encoding, writerArgs);
        this.move(bitLength);
    }

    @Override
    public void popContext(String logicalName, WithWriterArgs ... writerArgs) {
        try {
            --this.depth;
            this.indent();
            EndElement endElement = this.xmlEventFactory.createEndElement("", "", logicalName);
            this.xmlEventWriter.add(endElement);
            if (this.depth != 0) {
                this.newLine();
            }
        }
        catch (XMLStreamException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
        String context = this.stack.pop();
        if (!context.equals(logicalName)) {
            throw new PlcRuntimeException("Unexpected pop context '" + context + '\'' + ". Expected '" + logicalName + '\'');
        }
        if (this.stack.isEmpty()) {
            try {
                this.xmlEventWriter.close();
            }
            catch (XMLStreamException e) {
                throw new PlcRuntimeException((Throwable)e);
            }
        }
    }

    public String getXmlString() {
        try {
            return this.byteArrayOutputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }

    private void move(int bits) {
        this.pos += bits;
    }

    private void newLine() throws XMLStreamException {
        Characters newLine = this.xmlEventFactory.createCharacters("\n");
        this.xmlEventWriter.add(newLine);
    }

    private void indent() throws XMLStreamException {
        Characters indent = this.xmlEventFactory.createCharacters(StringUtils.repeat((String)"  ", (int)this.depth));
        this.xmlEventWriter.add(indent);
    }

    private void createAndAppend(String logicalName, String dataType, int bitLength, String data, WithWriterArgs ... writerArgs) {
        this.createAndAppend(logicalName, dataType, bitLength, data, (String)null, writerArgs);
    }

    private void createAndAppend(String logicalName, String dataType, int bitLength, String data, String encoding, WithWriterArgs ... writerArgs) {
        try {
            this.indent();
            StartElement startElement = this.xmlEventFactory.createStartElement("", "", this.sanitizeLogicalName(logicalName));
            this.xmlEventWriter.add(startElement);
            Attribute dataTypeAttribute = this.xmlEventFactory.createAttribute("dataType", dataType);
            this.xmlEventWriter.add(dataTypeAttribute);
            Attribute bitLengthAttribute = this.xmlEventFactory.createAttribute("bitLength", String.valueOf(bitLength));
            this.xmlEventWriter.add(bitLengthAttribute);
            String additionalStringRepresentation = this.extractAdditionalStringRepresentation(writerArgs);
            if (additionalStringRepresentation != null) {
                Attribute additionalStringRepresentationAttribute = this.xmlEventFactory.createAttribute("stringRepresentation", additionalStringRepresentation);
                this.xmlEventWriter.add(additionalStringRepresentationAttribute);
            }
            if (encoding != null) {
                Attribute encodingAttribute = this.xmlEventFactory.createAttribute("encoding", encoding);
                this.xmlEventWriter.add(encodingAttribute);
            }
            Characters dataCharacters = this.xmlEventFactory.createCharacters(data);
            this.xmlEventWriter.add(dataCharacters);
            EndElement endElement = this.xmlEventFactory.createEndElement("", "", this.sanitizeLogicalName(logicalName));
            this.xmlEventWriter.add(endElement);
            this.newLine();
        }
        catch (XMLStreamException e) {
            throw new PlcRuntimeException((Throwable)e);
        }
    }
}

