/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.model.PlcSubscriptionField;
import org.apache.plc4x.java.api.types.PlcSubscriptionType;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionField;
import org.apache.plc4x.java.spi.utils.Serializable;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultPlcSubscriptionRequest
implements PlcSubscriptionRequest,
Serializable {
    private final PlcSubscriber subscriber;
    private final LinkedHashMap<String, PlcSubscriptionField> fields;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultPlcSubscriptionRequest(@JsonProperty(value="subscriber") PlcSubscriber subscriber, @JsonProperty(value="fields") LinkedHashMap<String, PlcSubscriptionField> fields) {
        this.subscriber = subscriber;
        this.fields = fields;
    }

    @JsonIgnore
    public CompletableFuture<PlcSubscriptionResponse> execute() {
        return this.subscriber.subscribe(this);
    }

    @JsonIgnore
    public int getNumberOfFields() {
        return this.fields.size();
    }

    @JsonIgnore
    public LinkedHashSet<String> getFieldNames() {
        return new LinkedHashSet<String>(this.fields.keySet());
    }

    @JsonIgnore
    public PlcSubscriptionField getField(String name) {
        return this.fields.get(name);
    }

    @JsonIgnore
    public List<PlcSubscriptionField> getFields() {
        return new ArrayList<PlcSubscriptionField>(this.fields.values());
    }

    @JsonIgnore
    public List<Pair<String, PlcSubscriptionField>> getNamedFields() {
        return this.fields.entrySet().stream().map(stringPlcFieldEntry -> Pair.of((Object)((String)stringPlcFieldEntry.getKey()), (Object)((PlcSubscriptionField)stringPlcFieldEntry.getValue()))).collect(Collectors.toCollection(LinkedList::new));
    }

    public PlcSubscriber getSubscriber() {
        return this.subscriber;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws ParseException {
        writeBuffer.pushContext("PlcSubscriptionRequest", new WithWriterArgs[0]);
        writeBuffer.pushContext("fields", new WithWriterArgs[0]);
        for (Map.Entry<String, PlcSubscriptionField> fieldEntry : this.fields.entrySet()) {
            String fieldName = fieldEntry.getKey();
            writeBuffer.pushContext(fieldName, new WithWriterArgs[0]);
            PlcField field = (PlcField)fieldEntry.getValue();
            if (!(field instanceof Serializable)) {
                throw new RuntimeException("Error serializing. Field doesn't implement XmlSerializable");
            }
            ((Serializable)field).serialize(writeBuffer);
            writeBuffer.popContext(fieldName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("fields", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcSubscriptionRequest", new WithWriterArgs[0]);
    }

    public String toString() {
        return "DefaultPlcSubscriptionRequest{subscriber=" + this.subscriber + ", fields=" + this.fields + '}';
    }

    public static class Builder
    implements PlcSubscriptionRequest.Builder {
        private final PlcSubscriber subscriber;
        private final PlcFieldHandler fieldHandler;
        private final Map<String, BuilderItem> fields;

        public Builder(PlcSubscriber subscriber, PlcFieldHandler fieldHandler) {
            this.subscriber = subscriber;
            this.fieldHandler = fieldHandler;
            this.fields = new TreeMap<String, BuilderItem>();
        }

        public PlcSubscriptionRequest.Builder addCyclicField(String name, String fieldQuery, Duration pollingInterval) {
            this.fields.put(name, new BuilderItem(fieldQuery, PlcSubscriptionType.CYCLIC, pollingInterval));
            return this;
        }

        public PlcSubscriptionRequest.Builder addChangeOfStateField(String name, String fieldQuery) {
            this.fields.put(name, new BuilderItem(fieldQuery, PlcSubscriptionType.CHANGE_OF_STATE));
            return this;
        }

        public PlcSubscriptionRequest.Builder addEventField(String name, String fieldQuery) {
            if (this.fields.containsKey(name)) {
                throw new PlcRuntimeException("Duplicate field definition '" + name + "'");
            }
            this.fields.put(name, new BuilderItem(fieldQuery, PlcSubscriptionType.EVENT));
            return this;
        }

        public PlcSubscriptionRequest build() {
            LinkedHashMap<String, PlcSubscriptionField> parsedFields = new LinkedHashMap<String, PlcSubscriptionField>();
            this.fields.forEach((name, builderItem) -> {
                PlcField parsedField = this.fieldHandler.createField(((BuilderItem)builderItem).fieldQuery);
                parsedFields.put((String)name, new DefaultPlcSubscriptionField(((BuilderItem)builderItem).plcSubscriptionType, parsedField, ((BuilderItem)builderItem).duration));
            });
            return new DefaultPlcSubscriptionRequest(this.subscriber, parsedFields);
        }

        private static class BuilderItem {
            private final String fieldQuery;
            private final PlcSubscriptionType plcSubscriptionType;
            private final Duration duration;

            private BuilderItem(String fieldQuery, PlcSubscriptionType plcSubscriptionType) {
                this(fieldQuery, plcSubscriptionType, (Duration)null);
            }

            private BuilderItem(String fieldQuery, PlcSubscriptionType plcSubscriptionType, Duration duration) {
                this.fieldQuery = fieldQuery;
                this.plcSubscriptionType = plcSubscriptionType;
                this.duration = duration;
            }
        }
    }
}

