/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcBigInteger
extends PlcSimpleValue<BigInteger> {
    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcBigInteger(@JsonProperty(value="value") BigInteger value) {
        super(value, true);
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && !((BigInteger)this.value).equals(BigInteger.ZERO);
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(127L)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(-128L)) >= 0;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return ((BigInteger)this.value).byteValue();
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(32767L)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(-32768L)) >= 0;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return ((BigInteger)this.value).shortValue();
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) >= 0;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return ((BigInteger)this.value).intValue();
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return this.value != null && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0 && ((BigInteger)this.value).compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return ((BigInteger)this.value).longValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return (BigInteger)this.value;
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return true;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return ((BigInteger)this.value).floatValue();
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return ((BigInteger)this.value).doubleValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return new BigDecimal((BigInteger)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public String toString() {
        return ((BigInteger)this.value).toString();
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws ParseException {
        writeBuffer.writeBigInteger(this.getClass().getSimpleName(), ((BigInteger)this.value).bitLength(), (BigInteger)this.value, new WithWriterArgs[0]);
    }
}

