/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.utils.Serializable;
import org.apache.plc4x.java.spi.values.PlcValueAdapter;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcStruct
extends PlcValueAdapter {
    private final Map<String, PlcValue> map;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcStruct(@JsonProperty(value="map") Map<String, PlcValue> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    @Override
    @JsonIgnore
    public int getLength() {
        return 1;
    }

    @Override
    @JsonIgnore
    public boolean isStruct() {
        return true;
    }

    @Override
    @JsonIgnore
    public Set<String> getKeys() {
        return this.map.keySet();
    }

    @Override
    @JsonIgnore
    public boolean hasKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    @JsonIgnore
    public PlcValue getValue(String key) {
        return this.map.get(key);
    }

    @Override
    @JsonIgnore
    public Map<String, ? extends PlcValue> getStruct() {
        return this.map;
    }

    @JsonIgnore
    public String toString() {
        return "{" + this.map.entrySet().stream().map(entry -> String.format("\"%s\": %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(",")) + "}";
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws ParseException {
        writeBuffer.pushContext("PlcStruct", new WithWriterArgs[0]);
        for (Map.Entry<String, PlcValue> entry : this.map.entrySet()) {
            String fieldName = entry.getKey();
            writeBuffer.pushContext(fieldName, new WithWriterArgs[0]);
            PlcValue fieldValue = entry.getValue();
            if (!(fieldValue instanceof Serializable)) {
                throw new PlcRuntimeException("Error serializing. List item doesn't implement XmlSerializable");
            }
            ((Serializable)fieldValue).serialize(writeBuffer);
            writeBuffer.pushContext(fieldName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("PlcStruct", new WithWriterArgs[0]);
    }
}

