/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.nio.charset.StandardCharsets;
import java.time.LocalTime;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcTIME_OF_DAY
extends PlcSimpleValue<LocalTime> {
    public static PlcTIME_OF_DAY of(Object value) {
        if (value instanceof LocalTime) {
            return new PlcTIME_OF_DAY((LocalTime)value);
        }
        if (value instanceof Long) {
            return new PlcTIME_OF_DAY(LocalTime.ofSecondOfDay((Long)value / 1000L));
        }
        throw new PlcRuntimeException("Invalid value type");
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcTIME_OF_DAY(@JsonProperty(value="value") LocalTime value) {
        super(value, true);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcTIME_OF_DAY(@JsonProperty(value="value") Long value) {
        super(LocalTime.ofNanoOfDay(value * 1000000L), true);
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return ((LocalTime)this.value).toString();
    }

    @Override
    @JsonIgnore
    public boolean isTime() {
        return true;
    }

    @Override
    @JsonIgnore
    public LocalTime getTime() {
        return (LocalTime)this.value;
    }

    @JsonIgnore
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws ParseException {
        String valueString = ((LocalTime)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), valueString, new WithWriterArgs[0]);
    }
}

