/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.transport.rawsocket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ThreadPerChannelEventLoop;
import io.netty.channel.ThreadPerChannelEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import java.net.SocketAddress;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.connection.NettyChannelFactory;
import org.apache.plc4x.java.transport.rawsocket.RawSocketTransportConfiguration;
import org.apache.plc4x.java.utils.pcap.netty.config.PcapChannelOption;
import org.apache.plc4x.java.utils.rawsockets.netty.RawSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawSocketChannelFactory
extends NettyChannelFactory
implements HasConfiguration<RawSocketTransportConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(RawSocketChannelFactory.class);
    private RawSocketTransportConfiguration configuration;

    public RawSocketChannelFactory(SocketAddress address) {
        super(address);
    }

    public void setConfiguration(RawSocketTransportConfiguration configuration) {
        this.configuration = configuration;
    }

    public Class<? extends Channel> getChannel() {
        return RawSocketChannel.class;
    }

    public boolean isPassive() {
        return false;
    }

    public EventLoopGroup getEventLoopGroup() {
        return new ThreadPerChannelEventLoop((ThreadPerChannelEventLoopGroup)new OioEventLoopGroup());
    }

    public void configureBootstrap(Bootstrap bootstrap) {
        if (this.configuration != null) {
            logger.info("Configuring Bootstrap with {}", (Object)this.configuration);
            bootstrap.option(PcapChannelOption.RESOLVE_MAC_ADDRESS, (Object)this.configuration.isResolveMacAccess());
            if (this.configuration.getPcapPacketHandler() != null) {
                bootstrap.option(PcapChannelOption.PACKET_HANDLER, (Object)this.configuration.getPcapPacketHandler());
            }
        }
    }
}

