/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.embedded;

import io.netty.bootstrap.EventLoopProvider;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.embedded.EmbeddedChannelId;
import io.netty.channel.embedded.EmbeddedSocketAddress;
import io.netty.channel.embedded.Plc4xEmbeddedEventLoop;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.RecyclableArrayList;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

public class Plc4xEmbeddedChannel
extends AbstractChannel
implements EventLoopProvider {
    private static final SocketAddress LOCAL_ADDRESS = new EmbeddedSocketAddress();
    private static final SocketAddress REMOTE_ADDRESS = new EmbeddedSocketAddress();
    private static final ChannelHandler[] EMPTY_HANDLERS = new ChannelHandler[0];
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EmbeddedChannel.class);
    private static final ChannelMetadata METADATA_NO_DISCONNECT = new ChannelMetadata(false);
    private static final ChannelMetadata METADATA_DISCONNECT = new ChannelMetadata(true);
    private final Plc4xEmbeddedEventLoop loop = new Plc4xEmbeddedEventLoop();
    private final ChannelFutureListener recordExceptionListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            Plc4xEmbeddedChannel.this.recordException(future);
        }
    };
    private final ChannelMetadata metadata;
    private final ChannelConfig config;
    private Queue<Object> inboundMessages;
    private Queue<Object> outboundMessages;
    private Throwable lastException;
    private State state;

    public Plc4xEmbeddedChannel() {
        this(EMPTY_HANDLERS);
    }

    public Plc4xEmbeddedChannel(ChannelId channelId) {
        this(channelId, EMPTY_HANDLERS);
    }

    public Plc4xEmbeddedChannel(ChannelHandler ... handlers) {
        this(EmbeddedChannelId.INSTANCE, handlers);
    }

    public Plc4xEmbeddedChannel(boolean hasDisconnect, ChannelHandler ... handlers) {
        this(EmbeddedChannelId.INSTANCE, hasDisconnect, handlers);
    }

    public Plc4xEmbeddedChannel(boolean register, boolean hasDisconnect, ChannelHandler ... handlers) {
        this(EmbeddedChannelId.INSTANCE, register, hasDisconnect, handlers);
    }

    public Plc4xEmbeddedChannel(ChannelId channelId, ChannelHandler ... handlers) {
        this(channelId, false, handlers);
    }

    public Plc4xEmbeddedChannel(ChannelId channelId, boolean hasDisconnect, ChannelHandler ... handlers) {
        this(channelId, true, hasDisconnect, handlers);
    }

    public Plc4xEmbeddedChannel(ChannelId channelId, boolean register, boolean hasDisconnect, ChannelHandler ... handlers) {
        this(null, channelId, register, hasDisconnect, handlers);
    }

    public Plc4xEmbeddedChannel(Channel parent, ChannelId channelId, boolean register, boolean hasDisconnect, ChannelHandler ... handlers) {
        super(parent, channelId);
        this.metadata = Plc4xEmbeddedChannel.metadata(hasDisconnect);
        this.config = new DefaultChannelConfig((Channel)this);
        this.setup(register, handlers);
    }

    public Plc4xEmbeddedChannel(ChannelId channelId, boolean hasDisconnect, ChannelConfig config, ChannelHandler ... handlers) {
        super(null, channelId);
        this.metadata = Plc4xEmbeddedChannel.metadata(hasDisconnect);
        this.config = (ChannelConfig)ObjectUtil.checkNotNull((Object)config, (String)"config");
        this.setup(true, handlers);
    }

    @Override
    public EventLoop getEventLoop() {
        return this.loop;
    }

    public boolean isRegistered() {
        return false;
    }

    private static ChannelMetadata metadata(boolean hasDisconnect) {
        return hasDisconnect ? METADATA_DISCONNECT : METADATA_NO_DISCONNECT;
    }

    private void setup(boolean register, final ChannelHandler ... handlers) {
        ObjectUtil.checkNotNull((Object)handlers, (String)"handlers");
        ChannelPipeline p = this.pipeline();
        p.addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                for (ChannelHandler h : handlers) {
                    if (h == null) break;
                    pipeline.addLast(new ChannelHandler[]{h});
                }
            }
        }});
        if (register) {
            ChannelFuture future = this.loop.register((Channel)this);
            assert (future.isDone());
        }
    }

    public void register() throws Exception {
        ChannelFuture future = this.loop.register((Channel)this);
        assert (future.isDone());
        Throwable cause = future.cause();
        if (cause != null) {
            PlatformDependent.throwException((Throwable)cause);
        }
    }

    protected final DefaultChannelPipeline newChannelPipeline() {
        return new EmbeddedChannelPipeline(this);
    }

    public ChannelMetadata metadata() {
        return this.metadata;
    }

    public ChannelConfig config() {
        return this.config;
    }

    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    public boolean isActive() {
        return this.state == State.ACTIVE;
    }

    public Queue<Object> inboundMessages() {
        if (this.inboundMessages == null) {
            this.inboundMessages = new ArrayDeque<Object>();
        }
        return this.inboundMessages;
    }

    @Deprecated
    public Queue<Object> lastInboundBuffer() {
        return this.inboundMessages();
    }

    public Queue<Object> outboundMessages() {
        if (this.outboundMessages == null) {
            this.outboundMessages = new ArrayDeque<Object>();
        }
        return this.outboundMessages;
    }

    @Deprecated
    public Queue<Object> lastOutboundBuffer() {
        return this.outboundMessages();
    }

    public <T> T readInbound() {
        Object message = Plc4xEmbeddedChannel.poll(this.inboundMessages);
        if (message != null) {
            ReferenceCountUtil.touch((Object)message, (Object)"Caller of readInbound() will handle the message from this point");
        }
        return (T)message;
    }

    public <T> T readOutbound() {
        Object message = Plc4xEmbeddedChannel.poll(this.outboundMessages);
        if (message != null) {
            ReferenceCountUtil.touch((Object)message, (Object)"Caller of readOutbound() will handle the message from this point.");
        }
        return (T)message;
    }

    public boolean writeInbound(Object ... msgs) {
        this.ensureOpen();
        if (msgs.length == 0) {
            return Plc4xEmbeddedChannel.isNotEmpty(this.inboundMessages);
        }
        ChannelPipeline p = this.pipeline();
        for (Object m : msgs) {
            p.fireChannelRead(m);
        }
        this.flushInbound(false, this.voidPromise());
        return Plc4xEmbeddedChannel.isNotEmpty(this.inboundMessages);
    }

    public ChannelFuture writeOneInbound(Object msg) {
        return this.writeOneInbound(msg, this.newPromise());
    }

    public ChannelFuture writeOneInbound(Object msg, ChannelPromise promise) {
        if (this.checkOpen(true)) {
            this.pipeline().fireChannelRead(msg);
        }
        return this.checkException(promise);
    }

    public Plc4xEmbeddedChannel flushInbound() {
        this.flushInbound(true, this.voidPromise());
        return this;
    }

    private ChannelFuture flushInbound(boolean recordException, ChannelPromise promise) {
        if (this.checkOpen(recordException)) {
            this.pipeline().fireChannelReadComplete();
            this.runPendingTasks();
        }
        return this.checkException(promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeOutbound(Object ... msgs) {
        this.ensureOpen();
        if (msgs.length == 0) {
            return Plc4xEmbeddedChannel.isNotEmpty(this.outboundMessages);
        }
        RecyclableArrayList futures = RecyclableArrayList.newInstance((int)msgs.length);
        try {
            for (Object m : msgs) {
                if (m == null) break;
                futures.add((Object)this.write(m));
            }
            this.flushOutbound0();
            int size = futures.size();
            for (int i = 0; i < size; ++i) {
                ChannelFuture future = (ChannelFuture)futures.get(i);
                if (future.isDone()) {
                    this.recordException(future);
                    continue;
                }
                future.addListener((GenericFutureListener)this.recordExceptionListener);
            }
            this.checkException();
            int n = Plc4xEmbeddedChannel.isNotEmpty(this.outboundMessages) ? 1 : 0;
            return n != 0;
        }
        finally {
            futures.recycle();
        }
    }

    public ChannelFuture writeOneOutbound(Object msg) {
        return this.writeOneOutbound(msg, this.newPromise());
    }

    public ChannelFuture writeOneOutbound(Object msg, ChannelPromise promise) {
        if (this.checkOpen(true)) {
            return this.write(msg, promise);
        }
        return this.checkException(promise);
    }

    public Plc4xEmbeddedChannel flushOutbound() {
        if (this.checkOpen(true)) {
            this.flushOutbound0();
        }
        this.checkException(this.voidPromise());
        return this;
    }

    private void flushOutbound0() {
        this.runPendingTasks();
        this.flush();
    }

    public boolean finish() {
        return this.finish(false);
    }

    public boolean finishAndReleaseAll() {
        return this.finish(true);
    }

    private boolean finish(boolean releaseAll) {
        this.close();
        try {
            this.checkException();
            boolean bl = Plc4xEmbeddedChannel.isNotEmpty(this.inboundMessages) || Plc4xEmbeddedChannel.isNotEmpty(this.outboundMessages);
            return bl;
        }
        finally {
            if (releaseAll) {
                Plc4xEmbeddedChannel.releaseAll(this.inboundMessages);
                Plc4xEmbeddedChannel.releaseAll(this.outboundMessages);
            }
        }
    }

    public boolean releaseInbound() {
        return Plc4xEmbeddedChannel.releaseAll(this.inboundMessages);
    }

    public boolean releaseOutbound() {
        return Plc4xEmbeddedChannel.releaseAll(this.outboundMessages);
    }

    private static boolean releaseAll(Queue<Object> queue) {
        if (Plc4xEmbeddedChannel.isNotEmpty(queue)) {
            Object msg;
            while ((msg = queue.poll()) != null) {
                ReferenceCountUtil.release((Object)msg);
            }
            return true;
        }
        return false;
    }

    private void finishPendingTasks(boolean cancel) {
        this.runPendingTasks();
        if (cancel) {
            this.loop.cancelScheduledTasks();
        }
    }

    public final ChannelFuture close() {
        return this.close(this.newPromise());
    }

    public final ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    public final ChannelFuture close(ChannelPromise promise) {
        this.runPendingTasks();
        ChannelFuture future = super.close(promise);
        this.finishPendingTasks(true);
        return future;
    }

    public final ChannelFuture disconnect(ChannelPromise promise) {
        ChannelFuture future = super.disconnect(promise);
        this.finishPendingTasks(!this.metadata.hasDisconnect());
        return future;
    }

    private static boolean isNotEmpty(Queue<Object> queue) {
        return queue != null && !queue.isEmpty();
    }

    private static Object poll(Queue<Object> queue) {
        return queue != null ? queue.poll() : null;
    }

    public void runPendingTasks() {
        try {
            this.loop.runTasks();
        }
        catch (Exception e) {
            this.recordException(e);
        }
        try {
            this.loop.runScheduledTasks();
        }
        catch (Exception e) {
            this.recordException(e);
        }
    }

    public long runScheduledPendingTasks() {
        try {
            return this.loop.runScheduledTasks();
        }
        catch (Exception e) {
            this.recordException(e);
            return this.loop.nextScheduledTask();
        }
    }

    private void recordException(ChannelFuture future) {
        if (!future.isSuccess()) {
            this.recordException(future.cause());
        }
    }

    private void recordException(Throwable cause) {
        if (this.lastException == null) {
            this.lastException = cause;
        } else {
            logger.warn("More than one exception was raised. Will report only the first one and log others.", cause);
        }
    }

    private ChannelFuture checkException(ChannelPromise promise) {
        Throwable t = this.lastException;
        if (t != null) {
            this.lastException = null;
            if (promise.isVoid()) {
                PlatformDependent.throwException((Throwable)t);
            }
            return promise.setFailure(t);
        }
        return promise.setSuccess();
    }

    public void checkException() {
        this.checkException(this.voidPromise());
    }

    private boolean checkOpen(boolean recordException) {
        if (!this.isOpen()) {
            if (recordException) {
                this.recordException(new ClosedChannelException());
            }
            return false;
        }
        return true;
    }

    protected final void ensureOpen() {
        if (!this.checkOpen(true)) {
            this.checkException();
        }
    }

    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof Plc4xEmbeddedEventLoop;
    }

    protected SocketAddress localAddress0() {
        return this.isActive() ? LOCAL_ADDRESS : null;
    }

    protected SocketAddress remoteAddress0() {
        return this.isActive() ? REMOTE_ADDRESS : null;
    }

    protected void doRegister() throws Exception {
        this.state = State.ACTIVE;
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
    }

    protected void doDisconnect() throws Exception {
        if (!this.metadata.hasDisconnect()) {
            this.doClose();
        }
    }

    protected void doClose() throws Exception {
        this.state = State.CLOSED;
    }

    protected void doBeginRead() throws Exception {
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new EmbeddedUnsafe();
    }

    public Channel.Unsafe unsafe() {
        return ((EmbeddedUnsafe)super.unsafe()).wrapped;
    }

    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        Object msg;
        while ((msg = in.current()) != null) {
            ReferenceCountUtil.retain((Object)msg);
            this.handleOutboundMessage(msg);
            in.remove();
        }
    }

    protected void handleOutboundMessage(Object msg) {
        this.outboundMessages().add(msg);
    }

    protected void handleInboundMessage(Object msg) {
        this.inboundMessages().add(msg);
    }

    private final class EmbeddedChannelPipeline
    extends DefaultChannelPipeline {
        EmbeddedChannelPipeline(Plc4xEmbeddedChannel channel) {
            super((Channel)channel);
        }

        protected void onUnhandledInboundException(Throwable cause) {
            Plc4xEmbeddedChannel.this.recordException(cause);
        }

        protected void onUnhandledInboundMessage(ChannelHandlerContext ctx, Object msg) {
            Plc4xEmbeddedChannel.this.handleInboundMessage(msg);
        }
    }

    private final class EmbeddedUnsafe
    extends AbstractChannel.AbstractUnsafe {
        final Channel.Unsafe wrapped;

        private EmbeddedUnsafe() {
            super((AbstractChannel)Plc4xEmbeddedChannel.this);
            this.wrapped = new Channel.Unsafe(){

                public RecvByteBufAllocator.Handle recvBufAllocHandle() {
                    return EmbeddedUnsafe.this.recvBufAllocHandle();
                }

                public SocketAddress localAddress() {
                    return EmbeddedUnsafe.this.localAddress();
                }

                public SocketAddress remoteAddress() {
                    return EmbeddedUnsafe.this.remoteAddress();
                }

                public void register(EventLoop eventLoop, ChannelPromise promise) {
                    EmbeddedUnsafe.this.register(eventLoop, promise);
                    Plc4xEmbeddedChannel.this.runPendingTasks();
                }

                public void bind(SocketAddress localAddress, ChannelPromise promise) {
                    EmbeddedUnsafe.this.bind(localAddress, promise);
                    Plc4xEmbeddedChannel.this.runPendingTasks();
                }

                public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                    EmbeddedUnsafe.this.connect(remoteAddress, localAddress, promise);
                    Plc4xEmbeddedChannel.this.runPendingTasks();
                }

                public void disconnect(ChannelPromise promise) {
                    EmbeddedUnsafe.this.disconnect(promise);
                    Plc4xEmbeddedChannel.this.runPendingTasks();
                }

                public void close(ChannelPromise promise) {
                    EmbeddedUnsafe.this.close(promise);
                    Plc4xEmbeddedChannel.this.runPendingTasks();
                }

                public void closeForcibly() {
                    EmbeddedUnsafe.this.closeForcibly();
                    Plc4xEmbeddedChannel.this.runPendingTasks();
                }

                public void deregister(ChannelPromise promise) {
                    EmbeddedUnsafe.this.deregister(promise);
                    Plc4xEmbeddedChannel.this.runPendingTasks();
                }

                public void beginRead() {
                    EmbeddedUnsafe.this.beginRead();
                    Plc4xEmbeddedChannel.this.runPendingTasks();
                }

                public void write(Object msg, ChannelPromise promise) {
                    EmbeddedUnsafe.this.write(msg, promise);
                    Plc4xEmbeddedChannel.this.runPendingTasks();
                }

                public void flush() {
                    EmbeddedUnsafe.this.flush();
                    Plc4xEmbeddedChannel.this.runPendingTasks();
                }

                public ChannelPromise voidPromise() {
                    return EmbeddedUnsafe.this.voidPromise();
                }

                public ChannelOutboundBuffer outboundBuffer() {
                    return EmbeddedUnsafe.this.outboundBuffer();
                }
            };
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            this.safeSetSuccess(promise);
        }
    }

    private static enum State {
        OPEN,
        ACTIVE,
        CLOSED;

    }
}

