/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.rawsockets.attic;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.plc4x.java.utils.pcap.netty.exception.PcapException;
import org.apache.plc4x.java.utils.rawsockets.attic.RawSocketListener;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.util.LinkLayerAddress;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawEthernetSocket {
    private static final Logger logger = LoggerFactory.getLogger(RawEthernetSocket.class);
    private static final int SNAPLEN = 65536;
    private static final int READ_TIMEOUT = 10;
    private final EtherType etherType;
    private PcapNetworkInterface nif;
    private MacAddress remoteMacAddress;
    private MacAddress localMacAddress;
    private ExecutorService pool = Executors.newSingleThreadExecutor();
    private PcapHandle receiveHandle;
    private final List<RawSocketListener> listeners = new LinkedList<RawSocketListener>();

    public RawEthernetSocket(EtherType etherType) {
        this.etherType = etherType;
    }

    public void connect(String localMacAddress, String remoteMacAddress) throws PcapException {
        try {
            this.pool = Executors.newScheduledThreadPool(2);
            this.localMacAddress = MacAddress.getByName((String)localMacAddress);
            this.remoteMacAddress = MacAddress.getByName((String)remoteMacAddress);
            this.nif = null;
            for (PcapNetworkInterface dev : Pcaps.findAllDevs()) {
                if (dev.isLoopBack()) continue;
                for (LinkLayerAddress macAddress : dev.getLinkLayerAddresses()) {
                    if (!Arrays.equals(macAddress.getAddress(), this.localMacAddress.getAddress())) continue;
                    this.nif = dev;
                }
            }
            if (this.nif == null) {
                throw new PcapException("Unable to find local network device with mac address " + remoteMacAddress);
            }
            this.receiveHandle = this.nif.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10);
            String filterString = "ether proto " + this.etherType.valueAsString() + " and ether src " + this.remoteMacAddress.toString() + " and ether dst " + this.localMacAddress.toString();
            this.receiveHandle.setFilter(filterString, BpfProgram.BpfCompileMode.OPTIMIZE);
            PacketListener packetListener = packet -> {
                for (RawSocketListener listener : this.listeners) {
                    listener.packetReceived(packet.getRawData());
                }
            };
            this.pool.execute(() -> {
                try {
                    this.receiveHandle.loop(-1, packetListener);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error("Error receiving packet for protocol {} from MAC address {}", new Object[]{this.etherType.valueAsString(), remoteMacAddress, e});
                }
                catch (NotOpenException | PcapNativeException e) {
                    logger.error("Error receiving packet for protocol {} from MAC address {}", new Object[]{this.etherType.valueAsString(), remoteMacAddress, e});
                }
            });
        }
        catch (NotOpenException | PcapNativeException e) {
            throw new PcapException("Error setting up RawSocket", e);
        }
    }

    public void disconnect() throws PcapException {
    }

    public void write(byte[] rawData) throws PcapException {
        try (PcapHandle sendHandle = this.nif.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10);){
            final UnknownPacket.Builder packetBuilder = new UnknownPacket.Builder();
            packetBuilder.rawData(rawData);
            EthernetPacket.Builder etherBuilder = new EthernetPacket.Builder();
            etherBuilder.dstAddr(this.remoteMacAddress).srcAddr(this.localMacAddress).type(this.etherType).paddingAtBuild(true);
            etherBuilder.payloadBuilder((Packet.Builder)new AbstractPacket.AbstractBuilder(){

                public Packet build() {
                    return packetBuilder.build();
                }
            });
            EthernetPacket p = etherBuilder.build();
            sendHandle.sendPacket((Packet)p);
        }
        catch (NotOpenException | PcapNativeException e) {
            throw new PcapException("Error sending packet.", e);
        }
    }

    public void addListener(RawSocketListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RawSocketListener listener) {
        this.listeners.remove(listener);
    }
}

