/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.assemble;

import java.io.File;
import org.apache.pluto.util.assemble.Assembler;
import org.apache.pluto.util.assemble.AssemblerConfig;
import org.apache.pluto.util.assemble.ear.EarAssembler;
import org.apache.pluto.util.assemble.file.FileAssembler;
import org.apache.pluto.util.assemble.war.WarAssembler;

public class AssemblerFactory {
    private static final AssemblerFactory FACTORY = new AssemblerFactory();

    private AssemblerFactory() {
    }

    public static AssemblerFactory getFactory() {
        return FACTORY;
    }

    public Assembler createAssembler(AssemblerConfig config) {
        File source = config.getSource();
        if (source == null) {
            return new FileAssembler();
        }
        if (source.getName().toLowerCase().endsWith(".war")) {
            return new WarAssembler();
        }
        if (source.getName().toLowerCase().endsWith(".ear")) {
            return new EarAssembler();
        }
        return new FileAssembler();
    }
}

