/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.assemble.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.util.assemble.io.WebXmlStreamingAssembly;

public class JarStreamingAssembly {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$util$assemble$io$JarStreamingAssembly == null ? (class$org$apache$pluto$util$assemble$io$JarStreamingAssembly = JarStreamingAssembly.class$("org.apache.pluto.util.assemble.io.JarStreamingAssembly")) : class$org$apache$pluto$util$assemble$io$JarStreamingAssembly));
    static /* synthetic */ Class class$org$apache$pluto$util$assemble$io$JarStreamingAssembly;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assembleStream(JarInputStream source, JarOutputStream dest, String dispatchServletClass) throws IOException {
        try {
            JarEntry originalJarEntry;
            JarEntry servletXmlEntry = null;
            byte[] servletXmlBuffer = null;
            byte[] portletXmlBuffer = null;
            while ((originalJarEntry = source.getNextJarEntry()) != null) {
                JarEntry newJarEntry = JarStreamingAssembly.smartClone(originalJarEntry);
                originalJarEntry = null;
                if ("WEB-INF/web.xml".equals(newJarEntry.getName())) {
                    servletXmlEntry = newJarEntry;
                    servletXmlBuffer = IOUtils.toByteArray((InputStream)source);
                } else if ("WEB-INF/portlet.xml".equals(newJarEntry.getName())) {
                    portletXmlBuffer = IOUtils.toByteArray((InputStream)source);
                    dest.putNextEntry(newJarEntry);
                    IOUtils.write((byte[])portletXmlBuffer, (OutputStream)dest);
                } else {
                    dest.putNextEntry(newJarEntry);
                    IOUtils.copy((InputStream)source, (OutputStream)dest);
                }
                dest.closeEntry();
                ((FilterOutputStream)dest).flush();
            }
            if (portletXmlBuffer != null) {
                if (servletXmlBuffer == null) {
                    throw new FileNotFoundException("File 'WEB-INF/web.xml' could not be found in the source input stream.");
                }
                ByteArrayInputStream webXmlIn = new ByteArrayInputStream(servletXmlBuffer);
                ByteArrayInputStream portletXmlIn = new ByteArrayInputStream(portletXmlBuffer);
                ByteArrayOutputStream webXmlOut = new ByteArrayOutputStream(servletXmlBuffer.length);
                WebXmlStreamingAssembly.assembleStream(webXmlIn, portletXmlIn, webXmlOut, dispatchServletClass);
                IOUtils.copy((InputStream)webXmlIn, (OutputStream)webXmlOut);
                byte[] webXmlBytes = webXmlOut.toByteArray();
                if (servletXmlEntry.getMethod() == 0) {
                    servletXmlEntry.setSize(webXmlBytes.length);
                    CRC32 webXmlCrc = new CRC32();
                    webXmlCrc.update(webXmlBytes);
                    servletXmlEntry.setCrc(webXmlCrc.getValue());
                }
                dest.putNextEntry(servletXmlEntry);
                IOUtils.write((byte[])webXmlBytes, (OutputStream)dest);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Jar stream " + source + " successfully assembled."));
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"No portlet XML file was found, assembly was not required.");
                }
                dest.putNextEntry(servletXmlEntry);
                IOUtils.write(servletXmlBuffer, (OutputStream)dest);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Jar stream " + source + " successfully assembled."));
                }
            }
        }
        finally {
            ((FilterOutputStream)dest).flush();
            dest.close();
        }
    }

    private static JarEntry smartClone(JarEntry originalJarEntry) {
        JarEntry newJarEntry = new JarEntry(originalJarEntry.getName());
        newJarEntry.setComment(originalJarEntry.getComment());
        newJarEntry.setExtra(originalJarEntry.getExtra());
        newJarEntry.setMethod(originalJarEntry.getMethod());
        newJarEntry.setTime(originalJarEntry.getTime());
        if (newJarEntry.getMethod() == 0) {
            newJarEntry.setSize(originalJarEntry.getSize());
            newJarEntry.setCrc(originalJarEntry.getCrc());
        }
        return newJarEntry;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

