/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.assemble.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.pluto.descriptors.common.InitParamDD;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.descriptors.services.castor.PortletAppDescriptorServiceImpl;
import org.apache.pluto.descriptors.services.castor.WebAppDescriptorServiceImpl;
import org.apache.pluto.descriptors.servlet.LoadOnStartupDD;
import org.apache.pluto.descriptors.servlet.ServletDD;
import org.apache.pluto.descriptors.servlet.ServletMappingDD;
import org.apache.pluto.descriptors.servlet.WebAppDD;

public class WebXmlStreamingAssembly {
    public static void assembleStream(InputStream webXmlIn, InputStream portletXmlIn, OutputStream assembledWebXmlOut, String dispatchServletClass) throws IOException {
        if (dispatchServletClass == null || dispatchServletClass.length() == 0 || dispatchServletClass.trim().length() == 0) {
            dispatchServletClass = "org.apache.pluto.core.PortletServlet";
        }
        WebAppDescriptorServiceImpl descriptorSvc = new WebAppDescriptorServiceImpl();
        PortletAppDescriptorServiceImpl portletAppDescriptorSvc = new PortletAppDescriptorServiceImpl();
        WebAppDD webAppDDIn = descriptorSvc.read(webXmlIn);
        PortletAppDD portletAppDD = portletAppDescriptorSvc.read(portletXmlIn);
        portletXmlIn.close();
        Iterator it = portletAppDD.getPortlets().iterator();
        while (it.hasNext()) {
            PortletDD portlet = (PortletDD)it.next();
            String name = portlet.getPortletName();
            ServletDD servlet = new ServletDD();
            servlet.setServletName(name);
            servlet.setServletClass(dispatchServletClass);
            InitParamDD initParam = new InitParamDD();
            initParam.setParamName("portlet-name");
            initParam.setParamValue(name);
            servlet.getInitParams().add(initParam);
            LoadOnStartupDD onStartup = new LoadOnStartupDD();
            onStartup.setPriority(1);
            servlet.setLoadOnStartup(onStartup);
            ServletMappingDD servletMapping = new ServletMappingDD();
            servletMapping.setServletName(name);
            servletMapping.setUrlPattern("/PlutoInvoker/" + name);
            webAppDDIn.getServlets().add(servlet);
            webAppDDIn.getServletMappings().add(servletMapping);
        }
        descriptorSvc.write(webAppDDIn, assembledWebXmlOut);
    }
}

