/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.install;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.pluto.util.install.PortalInstaller;
import org.apache.pluto.util.install.file.jetty.Jetty5FileSystemInstaller;
import org.apache.pluto.util.install.file.tomcat5.Tomcat5FileSystemInstaller;
import org.apache.pluto.util.install.file.tomcat6.Tomcat6FileSystemInstaller;

public abstract class PortalInstallerFactory {
    private static final ArrayList HANDLERS = new ArrayList();
    static /* synthetic */ Class class$org$apache$pluto$util$install$PortalInstallerFactory;

    public static PortalInstaller getAppServerHandler(File installDir) {
        String className = System.getProperty((class$org$apache$pluto$util$install$PortalInstallerFactory == null ? (class$org$apache$pluto$util$install$PortalInstallerFactory = PortalInstallerFactory.class$("org.apache.pluto.util.install.PortalInstallerFactory")) : class$org$apache$pluto$util$install$PortalInstallerFactory).getName());
        PortalInstaller installer = null;
        installer = className != null ? PortalInstallerFactory.getHandler(className, installDir) : PortalInstallerFactory.findHandler(installDir);
        return installer;
    }

    private static PortalInstaller getHandler(String className, File installDir) {
        try {
            Class<?> cl = Class.forName(className);
            PortalInstaller ash = (PortalInstaller)cl.newInstance();
            if (ash.isValidInstallationDirectory(installDir)) {
                return ash;
            }
            throw new Exception("Invalid installation directory for handler: " + className);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate class: " + className, e);
        }
    }

    private static PortalInstaller findHandler(File installDir) {
        Iterator it = ((AbstractList)HANDLERS).iterator();
        while (it.hasNext()) {
            PortalInstaller ash = (PortalInstaller)it.next();
            if (!ash.isValidInstallationDirectory(installDir)) continue;
            return ash;
        }
        throw new RuntimeException("Unable to locate appropriate app server handler for: " + installDir.getAbsolutePath());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HANDLERS.add(new Tomcat6FileSystemInstaller());
        HANDLERS.add(new Tomcat5FileSystemInstaller());
        HANDLERS.add(new Jetty5FileSystemInstaller());
    }
}

