/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.document.wordprocessing.model.table;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.openxml4j.document.wordprocessing.ParagraphAlignment;
import org.openxml4j.document.wordprocessing.WordDocument;
import org.openxml4j.document.wordprocessing.model.table.CellWidth;
import org.openxml4j.document.wordprocessing.model.table.TableBorder;
import org.openxml4j.document.wordprocessing.model.table.TableCell;
import org.openxml4j.document.wordprocessing.model.table.TableLine;
import org.openxml4j.document.wordprocessing.model.table.TableWidthType;
import org.openxml4j.exceptions.OpenXML4JException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDescription {
    private static final String DEFAULT_COLOR_FOR_TABLE_HEADER = "a0aca3";
    private static Logger logger = Logger.getLogger((String)"org.openxml4j");
    private List<TableLine> lines;
    private TableBorder border;
    private ParagraphAlignment alignment;
    protected TableWidthType widthType = TableWidthType.TABLE_WIDTH_AUTO;

    public TableDescription(ParagraphAlignment p_alignment) {
        this.alignment = p_alignment;
        this.lines = new ArrayList<TableLine>();
    }

    public TableCell getCellAt(int line, int col) throws OpenXML4JException {
        if (line >= this.lines.size()) {
            String msg = "line should be <" + this.lines.size() + " line=" + line;
            logger.error((Object)msg);
            throw new OpenXML4JException(msg);
        }
        return this.lines.get(line).getCell(col);
    }

    public TableWidthType getWidthType() {
        return this.widthType;
    }

    public void setWidthType(TableWidthType widthType) {
        this.widthType = widthType;
    }

    public void appendLine(List<String> lineToAppend) {
        this.lines.add(new TableLine(lineToAppend, this.alignment));
    }

    public void appendBlankLine(List<CellWidth> listOfCells) {
        TableLine line = new TableLine();
        line.createLine(listOfCells);
        line.setAlignment(this.alignment);
        this.lines.add(line);
    }

    public void formatAsTableWithHeading() {
        if (this.lines.size() == 0) {
            logger.debug((Object)"nothing to format, table empty");
            return;
        }
        TableLine line = this.lines.get(0);
        line.setBackgroundColor(DEFAULT_COLOR_FOR_TABLE_HEADER);
        line.setBold();
    }

    public int getNbline() {
        return this.lines.size();
    }

    public void setAlignment(ParagraphAlignment alignment) {
        this.alignment = alignment;
    }

    public ParagraphAlignment getAlignment() {
        return this.alignment;
    }

    private Element buildColumnSize() {
        DocumentFactory factory = DocumentFactory.getInstance();
        Element columnSizeXml = factory.createElement(new QName("tblW", WordDocument.namespaceWord));
        columnSizeXml.addAttribute(new QName("w", WordDocument.namespaceWord), "0");
        columnSizeXml.addAttribute(new QName("type", WordDocument.namespaceWord), this.widthType.getOpenXmlName());
        return columnSizeXml;
    }

    public Element build() {
        DocumentFactory factory = DocumentFactory.getInstance();
        Element tableAsNode = factory.createElement(new QName("tbl", WordDocument.namespaceWord));
        Element tableProperties = tableAsNode.addElement(new QName("tblPr", WordDocument.namespaceWord));
        if (this.border == null) {
            this.border = new TableBorder();
        }
        this.border.build(tableProperties);
        tableProperties.add(this.buildColumnSize());
        for (TableLine line : this.lines) {
            tableAsNode.add(line.build());
        }
        return tableAsNode;
    }

    public void setBorder(TableBorder border) {
        this.border = border;
    }
}

