/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.samples.wordprocessingml;

import java.io.File;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.openxml4j.document.wordprocessing.ParagraphAlignment;
import org.openxml4j.document.wordprocessing.WordDocument;
import org.openxml4j.document.wordprocessing.model.table.BorderStyle;
import org.openxml4j.document.wordprocessing.model.table.TableBorder;
import org.openxml4j.document.wordprocessing.model.table.TableCellSize;
import org.openxml4j.document.wordprocessing.model.table.TableDescription;
import org.openxml4j.document.wordprocessing.model.table.TableWidthType;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;

public class DemoListingBuildingTable {
    private static Logger logger = Logger.getLogger((String)"org.openxml4j");
    private String testRoot;
    private String pathRootProject;

    public void init() {
        String packageName = this.getClass().getPackage().getName();
        String sep = File.separator;
        if (sep.equals("\\")) {
            sep = "\\\\";
        }
        this.pathRootProject = System.getProperty("user.dir") + File.separator + "src";
        this.testRoot = this.pathRootProject + File.separator + packageName.replaceAll("\\.", sep) + File.separator;
        PropertyConfigurator.configure((String)(this.pathRootProject + File.separator + "config.log4j"));
    }

    private TableDescription buildTestData() throws OpenXML4JException {
        int nbCol = 3;
        TableDescription tableDesc = new TableDescription(ParagraphAlignment.LEFT);
        TableBorder border = new TableBorder(BorderStyle.BORDER_STYLE_DOT_DASH, 8, "FF0000");
        tableDesc.setBorder(border);
        for (int lineNo = 0; lineNo < 5; ++lineNo) {
            ArrayList<String> line = new ArrayList<String>();
            for (int col = 0; col < nbCol; ++col) {
                line.add(new String("line=" + lineNo + " col=" + col));
            }
            tableDesc.appendLine(line);
        }
        tableDesc.getCellAt(1, 2).setCellSize(new TableCellSize(TableWidthType.TABLE_WIDTH_DXA, 4096));
        tableDesc.getCellAt(1, 2).setCellBackgroundColor("FA0000");
        return tableDesc;
    }

    private void buildTable(String inputFile, String outputFile) {
        File destFile = new File(outputFile);
        try {
            Package pack = Package.open(inputFile, PackageAccess.READ_WRITE);
            WordDocument docx = new WordDocument(pack);
            TableDescription tableDesc = this.buildTestData();
            docx.appendTable(tableDesc);
            docx.save(destFile);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void demoBuildTable() {
        this.buildTable(this.testRoot + "Blank.docx", this.testRoot + "table_example.docx");
    }

    public static void main(String[] args) {
        DemoListingBuildingTable demoTable = new DemoListingBuildingTable();
        demoTable.init();
        try {
            demoTable.demoBuildTable();
        }
        catch (Exception e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
    }
}

