/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.examples.html;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.examples.html.HSSFHtmlHelper;
import org.apache.poi.ss.examples.html.HtmlHelper;
import org.apache.poi.ss.examples.html.XSSFHtmlHelper;
import org.apache.poi.ss.format.CellFormat;
import org.apache.poi.ss.format.CellFormatResult;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ToHtml {
    private final Workbook wb;
    private final Appendable output;
    private boolean completeHTML;
    private Formatter out;
    private boolean gotBounds;
    private int firstColumn;
    private int endColumn;
    private HtmlHelper helper;
    private static final String DEFAULTS_CLASS = "excelDefaults";
    private static final String COL_HEAD_CLASS = "colHeader";
    private static final String ROW_HEAD_CLASS = "rowHeader";
    private static final Map<HorizontalAlignment, String> HALIGN = ToHtml.mapFor(HorizontalAlignment.LEFT, "left", HorizontalAlignment.CENTER, "center", HorizontalAlignment.RIGHT, "right", HorizontalAlignment.FILL, "left", HorizontalAlignment.JUSTIFY, "left", HorizontalAlignment.CENTER_SELECTION, "center");
    private static final Map<VerticalAlignment, String> VALIGN = ToHtml.mapFor(VerticalAlignment.BOTTOM, "bottom", VerticalAlignment.CENTER, "middle", VerticalAlignment.TOP, "top");
    private static final Map<BorderStyle, String> BORDER = ToHtml.mapFor(BorderStyle.DASH_DOT, "dashed 1pt", BorderStyle.DASH_DOT_DOT, "dashed 1pt", BorderStyle.DASHED, "dashed 1pt", BorderStyle.DOTTED, "dotted 1pt", BorderStyle.DOUBLE, "double 3pt", BorderStyle.HAIR, "solid 1px", BorderStyle.MEDIUM, "solid 2pt", BorderStyle.MEDIUM_DASH_DOT, "dashed 2pt", BorderStyle.MEDIUM_DASH_DOT_DOT, "dashed 2pt", BorderStyle.MEDIUM_DASHED, "dashed 2pt", BorderStyle.NONE, "none", BorderStyle.SLANTED_DASH_DOT, "dashed 2pt", BorderStyle.THICK, "solid 3pt", BorderStyle.THIN, "dashed 1pt");
    private static final int IDX_TABLE_WIDTH = -2;
    private static final int IDX_HEADER_COL_WIDTH = -1;

    private static <K, V> Map<K, V> mapFor(Object ... mapping) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < mapping.length; i += 2) {
            map.put(mapping[i], mapping[i + 1]);
        }
        return map;
    }

    public static ToHtml create(Workbook wb, Appendable output) {
        return new ToHtml(wb, output);
    }

    public static ToHtml create(String path, Appendable output) throws IOException {
        return ToHtml.create(new FileInputStream(path), output);
    }

    public static ToHtml create(InputStream in, Appendable output) throws IOException {
        Workbook wb = WorkbookFactory.create((InputStream)in);
        return ToHtml.create(wb, output);
    }

    private ToHtml(Workbook wb, Appendable output) {
        if (wb == null) {
            throw new NullPointerException("wb");
        }
        if (output == null) {
            throw new NullPointerException("output");
        }
        this.wb = wb;
        this.output = output;
        this.setupColorMap();
    }

    private void setupColorMap() {
        if (this.wb instanceof HSSFWorkbook) {
            this.helper = new HSSFHtmlHelper((HSSFWorkbook)this.wb);
        } else if (this.wb instanceof XSSFWorkbook) {
            this.helper = new XSSFHtmlHelper();
        } else {
            throw new IllegalArgumentException("unknown workbook type: " + this.wb.getClass().getSimpleName());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("usage: ToHtml inputWorkbook outputHtmlFile");
            return;
        }
        ToHtml toHtml = ToHtml.create(args[0], (Appendable)new PrintWriter(new FileWriter(args[1])));
        toHtml.setCompleteHTML(true);
        toHtml.printPage();
    }

    public void setCompleteHTML(boolean completeHTML) {
        this.completeHTML = completeHTML;
    }

    public void printPage() throws IOException {
        try {
            this.ensureOut();
            if (this.completeHTML) {
                this.out.format("<?xml version=\"1.0\" encoding=\"iso-8859-1\" ?>%n", new Object[0]);
                this.out.format("<html>%n", new Object[0]);
                this.out.format("<head>%n", new Object[0]);
                this.out.format("</head>%n", new Object[0]);
                this.out.format("<body>%n", new Object[0]);
            }
            this.print();
            if (this.completeHTML) {
                this.out.format("</body>%n", new Object[0]);
                this.out.format("</html>%n", new Object[0]);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.out);
            if (this.output instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)((Closeable)((Object)this.output)));
            }
        }
    }

    public void print() {
        this.printInlineStyle();
        this.printSheets();
    }

    private void printInlineStyle() {
        this.out.format("<style type=\"text/css\">%n", new Object[0]);
        this.printStyles();
        this.out.format("</style>%n", new Object[0]);
    }

    private void ensureOut() {
        if (this.out == null) {
            this.out = new Formatter(this.output);
        }
    }

    public void printStyles() {
        this.ensureOut();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("excelStyle.css")));){
            String line;
            while ((line = in.readLine()) != null) {
                this.out.format("%s%n", line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Reading standard css", e);
        }
        HashSet<CellStyle> seen = new HashSet<CellStyle>();
        for (int i = 0; i < this.wb.getNumberOfSheets(); ++i) {
            Sheet sheet = this.wb.getSheetAt(i);
            Iterator rows = sheet.rowIterator();
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                for (Cell cell : row) {
                    CellStyle style = cell.getCellStyle();
                    if (seen.contains(style)) continue;
                    this.printStyle(style);
                    seen.add(style);
                }
            }
        }
    }

    private void printStyle(CellStyle style) {
        this.out.format(".%s .%s {%n", DEFAULTS_CLASS, this.styleName(style));
        this.styleContents(style);
        this.out.format("}%n", new Object[0]);
    }

    private void styleContents(CellStyle style) {
        this.styleOut("text-align", style.getAlignment(), HALIGN);
        this.styleOut("vertical-align", style.getVerticalAlignment(), VALIGN);
        this.fontStyle(style);
        this.borderStyles(style);
        this.helper.colorStyles(style, this.out);
    }

    private void borderStyles(CellStyle style) {
        this.styleOut("border-left", style.getBorderLeft(), BORDER);
        this.styleOut("border-right", style.getBorderRight(), BORDER);
        this.styleOut("border-top", style.getBorderTop(), BORDER);
        this.styleOut("border-bottom", style.getBorderBottom(), BORDER);
    }

    private void fontStyle(CellStyle style) {
        int fontheight;
        Font font = this.wb.getFontAt(style.getFontIndexAsInt());
        if (font.getBold()) {
            this.out.format("  font-weight: bold;%n", new Object[0]);
        }
        if (font.getItalic()) {
            this.out.format("  font-style: italic;%n", new Object[0]);
        }
        if ((fontheight = font.getFontHeightInPoints()) == 9) {
            fontheight = 10;
        }
        this.out.format("  font-size: %dpt;%n", fontheight);
    }

    private String styleName(CellStyle style) {
        if (style == null) {
            style = this.wb.getCellStyleAt(0);
        }
        StringBuilder sb = new StringBuilder();
        try (Formatter fmt = new Formatter(sb);){
            fmt.format("style_%02x", style.getIndex());
            String string = fmt.toString();
            return string;
        }
    }

    private <K> void styleOut(String attr, K key, Map<K, String> mapping) {
        String value = mapping.get(key);
        if (value != null) {
            this.out.format("  %s: %s;%n", attr, value);
        }
    }

    private static CellType ultimateCellType(Cell c) {
        CellType type = c.getCellType();
        if (type == CellType.FORMULA) {
            type = c.getCachedFormulaResultType();
        }
        return type;
    }

    private void printSheets() {
        this.ensureOut();
        Sheet sheet = this.wb.getSheetAt(0);
        this.printSheet(sheet);
    }

    public void printSheet(Sheet sheet) {
        this.ensureOut();
        Map<Integer, Integer> widths = this.computeWidths(sheet);
        int tableWidth = widths.get(-2);
        this.out.format("<table class=%s style=\"width:%dpx;\">%n", DEFAULTS_CLASS, tableWidth);
        this.printCols(widths);
        this.printSheetContent(sheet);
        this.out.format("</table>%n", new Object[0]);
    }

    private Map<Integer, Integer> computeWidths(Sheet sheet) {
        TreeMap<Integer, Integer> ret = new TreeMap<Integer, Integer>();
        int tableWidth = 0;
        this.ensureColumnBounds(sheet);
        int lastRowNum = sheet.getLastRowNum();
        int headerCharCount = String.valueOf(lastRowNum).length();
        int headerColWidth = this.widthToPixels((headerCharCount + 1) * 256);
        ret.put(-1, headerColWidth);
        tableWidth += headerColWidth;
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            int colWidth = this.widthToPixels(sheet.getColumnWidth(i));
            ret.put(i, colWidth);
            tableWidth += colWidth;
        }
        ret.put(-2, tableWidth);
        return ret;
    }

    protected int widthToPixels(double widthUnits) {
        return (int)Math.round(widthUnits * 9.0 / 256.0);
    }

    private void printCols(Map<Integer, Integer> widths) {
        int headerColWidth = widths.get(-1);
        this.out.format("<col style=\"width:%dpx\"/>%n", headerColWidth);
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            int colWidth = widths.get(i);
            this.out.format("<col style=\"width:%dpx;\"/>%n", colWidth);
        }
    }

    private void ensureColumnBounds(Sheet sheet) {
        if (this.gotBounds) {
            return;
        }
        Iterator iter = sheet.rowIterator();
        this.firstColumn = iter.hasNext() ? Integer.MAX_VALUE : 0;
        this.endColumn = 0;
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            short firstCell = row.getFirstCellNum();
            if (firstCell < 0) continue;
            this.firstColumn = Math.min(this.firstColumn, firstCell);
            this.endColumn = Math.max(this.endColumn, row.getLastCellNum());
        }
        this.gotBounds = true;
    }

    private void printColumnHeads() {
        this.out.format("<thead>%n", new Object[0]);
        this.out.format("  <tr class=%s>%n", COL_HEAD_CLASS);
        this.out.format("    <th class=%s>&#x25CA;</th>%n", COL_HEAD_CLASS);
        StringBuilder colName = new StringBuilder();
        for (int i = this.firstColumn; i < this.endColumn; ++i) {
            colName.setLength(0);
            int cnum = i;
            do {
                colName.insert(0, (char)(65 + cnum % 26));
            } while ((cnum /= 26) > 0);
            this.out.format("    <th class=%s>%s</th>%n", COL_HEAD_CLASS, colName);
        }
        this.out.format("  </tr>%n", new Object[0]);
        this.out.format("</thead>%n", new Object[0]);
    }

    private void printSheetContent(Sheet sheet) {
        this.printColumnHeads();
        this.out.format("<tbody>%n", new Object[0]);
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            this.out.format("  <tr>%n", new Object[0]);
            this.out.format("    <td class=%s>%d</td>%n", ROW_HEAD_CLASS, row.getRowNum() + 1);
            for (int i = this.firstColumn; i < this.endColumn; ++i) {
                Cell cell;
                String content = "&nbsp;";
                String attrs = "";
                CellStyle style = null;
                if (i >= row.getFirstCellNum() && i < row.getLastCellNum() && (cell = row.getCell(i)) != null) {
                    style = cell.getCellStyle();
                    attrs = this.tagStyle(cell, style);
                    CellFormat cf = CellFormat.getInstance((String)style.getDataFormatString());
                    CellFormatResult result = cf.apply(cell);
                    content = result.text;
                    if (content.isEmpty()) {
                        content = "&nbsp;";
                    }
                }
                this.out.format("    <td class=%s %s>%s</td>%n", this.styleName(style), attrs, content);
            }
            this.out.format("  </tr>%n", new Object[0]);
        }
        this.out.format("</tbody>%n", new Object[0]);
    }

    private String tagStyle(Cell cell, CellStyle style) {
        if (style.getAlignment() == HorizontalAlignment.GENERAL) {
            switch (ToHtml.ultimateCellType(cell)) {
                case STRING: {
                    return "style=\"text-align: left;\"";
                }
                case BOOLEAN: 
                case ERROR: {
                    return "style=\"text-align: center;\"";
                }
            }
        }
        return "";
    }
}

