/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.chart.AxisOrientation;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFChart;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSlide;

public class BarChartDemo {
    private static void usage() {
        System.out.println("Usage: BarChartDemo <bar-chart-template.pptx> <bar-chart-data.txt>");
        System.out.println("    bar-chart-template.pptx     template with a bar chart");
        System.out.println("    bar-chart-data.txt          the model to set. First line is chart title, then go pairs {axis-label value}");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            BarChartDemo.usage();
            return;
        }
        try (FileInputStream argIS = new FileInputStream(args[0]);
             BufferedReader modelReader = new BufferedReader(new FileReader(args[1]));){
            String ln;
            String chartTitle = modelReader.readLine();
            ArrayList<String> listCategories = new ArrayList<String>(3);
            ArrayList<Double> listValues = new ArrayList<Double>(3);
            while ((ln = modelReader.readLine()) != null) {
                String[] vals = ln.split("\\s+");
                listCategories.add(vals[0]);
                listValues.add(Double.valueOf(vals[1]));
            }
            String[] categories = listCategories.toArray(new String[listCategories.size()]);
            Double[] values = listValues.toArray(new Double[listValues.size()]);
            try (XMLSlideShow pptx = new XMLSlideShow((InputStream)argIS);){
                XSLFSlide slide = (XSLFSlide)pptx.getSlides().get(0);
                BarChartDemo.setBarData(BarChartDemo.findChart(slide), chartTitle, categories, values);
                XSLFChart chart = BarChartDemo.findChart(pptx.createSlide().importContent((XSLFSheet)slide));
                BarChartDemo.setColumnData(chart, "Column variant");
                try (FileOutputStream out = new FileOutputStream("bar-chart-demo-output.pptx");){
                    pptx.write((OutputStream)out);
                }
            }
        }
    }

    private static void setBarData(XSLFChart chart, String chartTitle, String[] categories, Double[] values) {
        List series = chart.getChartSeries();
        XDDFBarChartData bar = (XDDFBarChartData)series.get(0);
        int numOfPoints = categories.length;
        String categoryDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, 0, 0));
        String valuesDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, 1, 1));
        XDDFCategoryDataSource categoriesData = XDDFDataSourcesFactory.fromArray((String[])categories, (String)categoryDataRange);
        XDDFNumericalDataSource valuesData = XDDFDataSourcesFactory.fromArray((Number[])values, (String)valuesDataRange);
        ((XDDFChartData.Series)bar.getSeries().get(0)).replaceData((XDDFDataSource)categoriesData, valuesData);
        ((XDDFChartData.Series)bar.getSeries().get(0)).setTitle(chartTitle, chart.setSheetTitle(chartTitle));
        chart.plot((XDDFChartData)bar);
    }

    private static void setColumnData(XSLFChart chart, String chartTitle) {
        List series = chart.getChartSeries();
        XDDFBarChartData bar = (XDDFBarChartData)series.get(0);
        ((XDDFChartData.Series)bar.getSeries().get(0)).setTitle(chartTitle, chart.setSheetTitle(chartTitle));
        bar.setBarDirection(BarDirection.COL);
        bar.getCategoryAxis().setOrientation(AxisOrientation.MAX_MIN);
        ((XDDFValueAxis)bar.getValueAxes().get(0)).setPosition(AxisPosition.TOP);
    }

    private static XSLFChart findChart(XSLFSlide slide) {
        XSLFChart chart = null;
        for (POIXMLDocumentPart part : slide.getRelations()) {
            if (!(part instanceof XSLFChart)) continue;
            chart = (XSLFChart)part;
            break;
        }
        if (chart == null) {
            throw new IllegalStateException("chart not found in the template");
        }
        return chart;
    }
}

