/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.examples;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ScatterChart {
    public static void main(String[] args) throws IOException {
        try (XSSFWorkbook wb = new XSSFWorkbook();){
            XSSFSheet sheet = wb.createSheet("Sheet 1");
            int NUM_OF_ROWS = 3;
            int NUM_OF_COLUMNS = 10;
            for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
                XSSFRow row = sheet.createRow((int)((short)rowIndex));
                for (int colIndex = 0; colIndex < 10; ++colIndex) {
                    Cell cell = row.createCell((int)((short)colIndex));
                    cell.setCellValue((double)(colIndex * (rowIndex + 1)));
                }
            }
            XSSFDrawing drawing = sheet.createDrawingPatriarch();
            XSSFClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, 0, 5, 10, 15);
            XSSFChart chart = drawing.createChart(anchor);
            XDDFChartLegend legend = chart.getOrAddLegend();
            legend.setPosition(LegendPosition.TOP_RIGHT);
            XDDFValueAxis bottomAxis = chart.createValueAxis(AxisPosition.BOTTOM);
            XDDFValueAxis leftAxis = chart.createValueAxis(AxisPosition.LEFT);
            leftAxis.setCrosses(AxisCrosses.AUTO_ZERO);
            XDDFNumericalDataSource xs = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)sheet, (CellRangeAddress)new CellRangeAddress(0, 0, 0, 9));
            XDDFNumericalDataSource ys1 = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)sheet, (CellRangeAddress)new CellRangeAddress(1, 1, 0, 9));
            XDDFNumericalDataSource ys2 = XDDFDataSourcesFactory.fromNumericCellRange((XSSFSheet)sheet, (CellRangeAddress)new CellRangeAddress(2, 2, 0, 9));
            XDDFChartData data = chart.createData(ChartTypes.SCATTER, (XDDFChartAxis)bottomAxis, leftAxis);
            data.addSeries((XDDFDataSource)xs, ys1);
            data.addSeries((XDDFDataSource)xs, ys2);
            chart.plot(data);
            try (FileOutputStream fileOut = new FileOutputStream("ooxml-scatter-chart.xlsx");){
                wb.write((OutputStream)fileOut);
            }
        }
    }
}

