/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel.examples;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.chart.AxisOrientation;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class BarChartExampleDOCX {
    private static void usage() {
        System.out.println("Usage: BarChartDemo <bar-chart-template.docx> <bar-chart-data.txt>");
        System.out.println("    bar-chart-template.docx     template with a bar chart");
        System.out.println("    bar-chart-data.txt          the model to set. First line is chart title, then go pairs {axis-label value}");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            BarChartExampleDOCX.usage();
            return;
        }
        try (FileInputStream argIS = new FileInputStream(args[0]);
             BufferedReader modelReader = new BufferedReader(new FileReader(args[1]));){
            String ln;
            String chartTitle = modelReader.readLine();
            ArrayList<String> listCategories = new ArrayList<String>(3);
            ArrayList<Double> listValues = new ArrayList<Double>(3);
            while ((ln = modelReader.readLine()) != null) {
                String[] vals = ln.split("\\s+");
                listCategories.add(vals[0]);
                listValues.add(Double.valueOf(vals[1]));
            }
            String[] categories = listCategories.toArray(new String[listCategories.size()]);
            Double[] values = listValues.toArray(new Double[listValues.size()]);
            try (XWPFDocument doc = new XWPFDocument((InputStream)argIS);){
                XWPFChart chart = (XWPFChart)doc.getCharts().get(0);
                BarChartExampleDOCX.setBarData(chart, chartTitle, categories, values);
                chart = (XWPFChart)doc.getCharts().get(1);
                BarChartExampleDOCX.setColumnData(chart, "Column variant");
                try (FileOutputStream out = new FileOutputStream("bar-chart-demo-output.docx");){
                    doc.write((OutputStream)out);
                }
            }
        }
        System.out.println("Done");
    }

    private static void setBarData(XWPFChart chart, String chartTitle, String[] categories, Double[] values) {
        List series = chart.getChartSeries();
        XDDFBarChartData bar = (XDDFBarChartData)series.get(0);
        int numOfPoints = categories.length;
        String categoryDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, 0, 0));
        String valuesDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, 1, 1));
        String valuesDataRange2 = chart.formatRange(new CellRangeAddress(1, numOfPoints, 2, 2));
        XDDFCategoryDataSource categoriesData = XDDFDataSourcesFactory.fromArray((String[])categories, (String)categoryDataRange, (int)0);
        XDDFNumericalDataSource valuesData = XDDFDataSourcesFactory.fromArray((Number[])values, (String)valuesDataRange, (int)1);
        values[2] = 10.0;
        XDDFNumericalDataSource valuesData2 = XDDFDataSourcesFactory.fromArray((Number[])values, (String)valuesDataRange2, (int)2);
        ((XDDFChartData.Series)bar.getSeries().get(0)).replaceData((XDDFDataSource)categoriesData, valuesData);
        bar.addSeries((XDDFDataSource)categoriesData, valuesData2);
        ((XDDFChartData.Series)bar.getSeries().get(0)).setTitle(chartTitle, chart.setSheetTitle(chartTitle));
        chart.plot((XDDFChartData)bar);
    }

    private static void setColumnData(XWPFChart chart, String chartTitle) {
        List series = chart.getChartSeries();
        XDDFBarChartData bar = (XDDFBarChartData)series.get(0);
        ((XDDFChartData.Series)bar.getSeries().get(0)).setTitle(chartTitle, chart.setSheetTitle(chartTitle));
        bar.setBarDirection(BarDirection.COL);
        bar.getCategoryAxis().setOrientation(AxisOrientation.MAX_MIN);
        ((XDDFValueAxis)bar.getValueAxes().get(0)).setPosition(AxisPosition.TOP);
    }
}

