/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.poibrowser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.util.IOUtils;

class DocumentDescriptor {
    private static final int MAX_RECORD_LENGTH = 100000;
    String name;
    POIFSDocumentPath path;
    DocumentInputStream stream;
    int size;
    byte[] bytes;

    public DocumentDescriptor(String name, POIFSDocumentPath path, DocumentInputStream stream, int nrOfBytes) {
        this.name = name;
        this.path = path;
        this.stream = stream;
        try {
            if (stream.markSupported()) {
                stream.mark(nrOfBytes);
                this.bytes = IOUtils.toByteArray((InputStream)stream, (long)nrOfBytes, (int)100000);
                stream.reset();
            } else {
                this.bytes = new byte[0];
            }
            this.size = this.bytes.length + stream.available();
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }
}

