/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFChart;
import org.apache.poi.xslf.usermodel.XSLFSlide;

public class ChartFromScratch {
    private static void usage() {
        System.out.println("Usage: BarChartExample <bar-chart-data.txt>");
        System.out.println("    bar-chart-data.txt          the model to set. First line is chart title, then go pairs {axis-label value}");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            ChartFromScratch.usage();
            return;
        }
        try (BufferedReader modelReader = new BufferedReader(new FileReader(args[0]));){
            String ln;
            String chartTitle = modelReader.readLine();
            String[] series = modelReader.readLine().split(",");
            ArrayList<String> listLanguages = new ArrayList<String>(10);
            ArrayList<Double> listCountries = new ArrayList<Double>(10);
            ArrayList<Double> listSpeakers = new ArrayList<Double>(10);
            while ((ln = modelReader.readLine()) != null) {
                String[] vals = ln.split(",");
                listCountries.add(Double.valueOf(vals[0]));
                listSpeakers.add(Double.valueOf(vals[1]));
                listLanguages.add(vals[2]);
            }
            String[] categories = listLanguages.toArray(new String[listLanguages.size()]);
            Double[] values1 = listCountries.toArray(new Double[listCountries.size()]);
            Double[] values2 = listSpeakers.toArray(new Double[listSpeakers.size()]);
            try {
                XMLSlideShow ppt = new XMLSlideShow();
                XSLFSlide slide = ppt.createSlide();
                XSLFChart chart = ppt.createChart();
                Rectangle rect2D = new Rectangle(10, 10, 500000, 500000);
                slide.addChart(chart, (Rectangle2D)rect2D);
                ChartFromScratch.setBarData(chart, chartTitle, series, categories, values1, values2);
                try (FileOutputStream out = new FileOutputStream("bar-chart-demo-output.pptx");){
                    ppt.write((OutputStream)out);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Done");
    }

    private static void setBarData(XSLFChart chart, String chartTitle, String[] series, String[] categories, Double[] values1, Double[] values2) {
        XDDFCategoryAxis bottomAxis = chart.createCategoryAxis(AxisPosition.BOTTOM);
        bottomAxis.setTitle(series[2]);
        XDDFValueAxis leftAxis = chart.createValueAxis(AxisPosition.LEFT);
        leftAxis.setTitle(series[0] + "," + series[1]);
        leftAxis.setCrosses(AxisCrosses.AUTO_ZERO);
        int numOfPoints = categories.length;
        String categoryDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, 0, 0));
        String valuesDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, 1, 1));
        String valuesDataRange2 = chart.formatRange(new CellRangeAddress(1, numOfPoints, 2, 2));
        XDDFCategoryDataSource categoriesData = XDDFDataSourcesFactory.fromArray((String[])categories, (String)categoryDataRange, (int)0);
        XDDFNumericalDataSource valuesData = XDDFDataSourcesFactory.fromArray((Number[])values1, (String)valuesDataRange, (int)1);
        values1[6] = 16.0;
        XDDFNumericalDataSource valuesData2 = XDDFDataSourcesFactory.fromArray((Number[])values2, (String)valuesDataRange2, (int)2);
        XDDFBarChartData bar = (XDDFBarChartData)chart.createData(ChartTypes.BAR, (XDDFChartAxis)bottomAxis, leftAxis);
        XDDFBarChartData.Series series1 = (XDDFBarChartData.Series)bar.addSeries((XDDFDataSource)categoriesData, valuesData);
        series1.setTitle(series[0], chart.setSheetTitle(series[0], 1));
        XDDFBarChartData.Series series2 = (XDDFBarChartData.Series)bar.addSeries((XDDFDataSource)categoriesData, valuesData2);
        series2.setTitle(series[1], chart.setSheetTitle(series[1], 2));
        bar.setVaryColors(true);
        bar.setBarDirection(BarDirection.COL);
        chart.plot((XDDFChartData)bar);
        XDDFChartLegend legend = chart.getOrAddLegend();
        legend.setPosition(LegendPosition.LEFT);
        legend.setOverlay(false);
        chart.setTitleText(chartTitle);
        chart.setTitleOverlay(false);
    }
}

