/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.ss;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hssf.usermodel.HSSFObjectData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.xmlbeans.XmlException;

public final class LoadEmbedded {
    private LoadEmbedded() {
    }

    public static void main(String[] args) throws IOException, EncryptedDocumentException, OpenXML4JException, XmlException {
        Workbook wb = WorkbookFactory.create((File)new File(args[0]));
        LoadEmbedded.loadEmbedded(wb);
    }

    public static void loadEmbedded(Workbook wb) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        if (wb instanceof HSSFWorkbook) {
            LoadEmbedded.loadEmbedded((HSSFWorkbook)wb);
        } else if (wb instanceof XSSFWorkbook) {
            LoadEmbedded.loadEmbedded((XSSFWorkbook)wb);
        } else {
            throw new IllegalArgumentException(wb.getClass().getName());
        }
    }

    public static void loadEmbedded(HSSFWorkbook workbook) throws IOException {
        for (HSSFObjectData obj : workbook.getAllEmbeddedObjects()) {
            DirectoryNode dn;
            String oleName = obj.getOLE2ClassName();
            if (oleName.equals("Worksheet")) {
                dn = (DirectoryNode)obj.getDirectory();
                HSSFWorkbook embeddedWorkbook = new HSSFWorkbook(dn, false);
                embeddedWorkbook.close();
                continue;
            }
            if (oleName.equals("Document")) {
                dn = (DirectoryNode)obj.getDirectory();
                HWPFDocument embeddedWordDocument = new HWPFDocument(dn);
                embeddedWordDocument.close();
                continue;
            }
            if (oleName.equals("Presentation")) {
                dn = (DirectoryNode)obj.getDirectory();
                HSLFSlideShow embeddedSlieShow = new HSLFSlideShow(dn);
                embeddedSlieShow.close();
                continue;
            }
            if (obj.hasDirectoryEntry()) {
                dn = (DirectoryNode)obj.getDirectory();
                for (Entry entry : dn) {
                }
                continue;
            }
            byte[] byArray = obj.getObjectData();
        }
    }

    public static void loadEmbedded(XSSFWorkbook workbook) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        for (PackagePart pPart : workbook.getAllEmbeddedParts()) {
            HSLFSlideShow slideShow2;
            HWPFDocument document2;
            HSSFWorkbook embeddedWorkbook2;
            Throwable throwable;
            InputStream stream;
            String contentType = pPart.getContentType();
            if (contentType.equals("application/vnd.ms-excel")) {
                stream = pPart.getInputStream();
                throwable = null;
                try {
                    embeddedWorkbook2 = new HSSFWorkbook(stream);
                    embeddedWorkbook2.close();
                    continue;
                }
                catch (Throwable embeddedWorkbook2) {
                    throwable = embeddedWorkbook2;
                    throw embeddedWorkbook2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable embeddedWorkbook2) {
                            throwable.addSuppressed(embeddedWorkbook2);
                        }
                        continue;
                    }
                    stream.close();
                    continue;
                }
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                stream = pPart.getInputStream();
                throwable = null;
                try {
                    embeddedWorkbook2 = new XSSFWorkbook(stream);
                    embeddedWorkbook2.close();
                    continue;
                }
                catch (Throwable embeddedWorkbook3) {
                    throwable = embeddedWorkbook3;
                    throw embeddedWorkbook3;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable embeddedWorkbook3) {
                            throwable.addSuppressed(embeddedWorkbook3);
                        }
                        continue;
                    }
                    stream.close();
                    continue;
                }
            }
            if (contentType.equals("application/msword")) {
                stream = pPart.getInputStream();
                throwable = null;
                try {
                    document2 = new HWPFDocument(stream);
                    document2.close();
                    continue;
                }
                catch (Throwable document2) {
                    throwable = document2;
                    throw document2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable document2) {
                            throwable.addSuppressed(document2);
                        }
                        continue;
                    }
                    stream.close();
                    continue;
                }
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                stream = pPart.getInputStream();
                throwable = null;
                try {
                    document2 = new XWPFDocument(stream);
                    document2.close();
                    continue;
                }
                catch (Throwable document3) {
                    throwable = document3;
                    throw document3;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable document3) {
                            throwable.addSuppressed(document3);
                        }
                        continue;
                    }
                    stream.close();
                    continue;
                }
            }
            if (contentType.equals("application/vnd.ms-powerpoint")) {
                stream = pPart.getInputStream();
                throwable = null;
                try {
                    slideShow2 = new HSLFSlideShow(stream);
                    slideShow2.close();
                    continue;
                }
                catch (Throwable slideShow2) {
                    throwable = slideShow2;
                    throw slideShow2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable slideShow2) {
                            throwable.addSuppressed(slideShow2);
                        }
                        continue;
                    }
                    stream.close();
                    continue;
                }
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
                stream = pPart.getInputStream();
                throwable = null;
                try {
                    slideShow2 = new XMLSlideShow(stream);
                    slideShow2.close();
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                    continue;
                }
            }
            System.out.println("Unknown Embedded Document: " + contentType);
            InputStream inputStream = pPart.getInputStream();
            throwable = null;
            if (inputStream == null) continue;
            if (throwable != null) {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                continue;
            }
            inputStream.close();
        }
    }
}

