/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xssf.eventusermodel;

import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.examples.xssf.usermodel.LoadPasswordProtectedXlsx;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.util.ZipEntrySource;
import org.apache.poi.poifs.crypt.temp.AesZipFileZipEntrySource;
import org.apache.poi.xssf.eventusermodel.XSSFReader;

public final class LoadPasswordProtectedXlsxStreaming {
    private LoadPasswordProtectedXlsxStreaming() {
    }

    public static void main(String[] args) throws Exception {
        LoadPasswordProtectedXlsx.execute(args, LoadPasswordProtectedXlsxStreaming::printSheetCount);
    }

    private static void printSheetCount(InputStream inputStream) throws Exception {
        try (AesZipFileZipEntrySource source = AesZipFileZipEntrySource.createZipEntrySource((InputStream)inputStream);
             OPCPackage pkg = OPCPackage.open((ZipEntrySource)source);){
            XSSFReader reader = new XSSFReader(pkg);
            Iterator iter = reader.getSheetsData();
            int count = 0;
            while (iter.hasNext()) {
                InputStream stream = (InputStream)iter.next();
                Throwable throwable = null;
                try {
                    ++count;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            System.out.println("sheet count: " + count);
        }
    }
}

