/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.excelant;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Supplier;
import org.apache.poi.ss.excelant.ExcelAntEvaluateCell;
import org.apache.poi.ss.excelant.ExcelAntHandlerTask;
import org.apache.poi.ss.excelant.ExcelAntSet;
import org.apache.poi.ss.excelant.ExcelAntSetDoubleCell;
import org.apache.poi.ss.excelant.ExcelAntSetFormulaCell;
import org.apache.poi.ss.excelant.ExcelAntSetStringCell;
import org.apache.poi.ss.excelant.util.ExcelAntEvaluationResult;
import org.apache.poi.ss.excelant.util.ExcelAntWorkbookUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ExcelAntTest
extends Task {
    private LinkedList<ExcelAntEvaluateCell> evaluators = new LinkedList();
    private LinkedList<Task> testTasks;
    private String name;
    private double globalPrecision;
    private boolean showSuccessDetails;
    private boolean showFailureDetail;
    LinkedList<String> failureMessages = new LinkedList();
    private ExcelAntWorkbookUtil workbookUtil;
    private boolean passed = true;

    public ExcelAntTest() {
        this.testTasks = new LinkedList();
    }

    public void setPrecision(double precision) {
        this.globalPrecision = precision;
    }

    public void setWorkbookUtil(ExcelAntWorkbookUtil wbUtil) {
        this.workbookUtil = wbUtil;
    }

    public void setShowFailureDetail(boolean value) {
        this.showFailureDetail = value;
    }

    public void setName(String nm) {
        this.name = nm;
    }

    public String getName() {
        return this.name;
    }

    public void setShowSuccessDetails(boolean details) {
        this.showSuccessDetails = details;
    }

    public boolean showSuccessDetails() {
        return this.showSuccessDetails;
    }

    public void addSetDouble(ExcelAntSetDoubleCell setter) {
        this.addSetter(setter);
    }

    public void addSetString(ExcelAntSetStringCell setter) {
        this.addSetter(setter);
    }

    public void addSetFormula(ExcelAntSetFormulaCell setter) {
        this.addSetter(setter);
    }

    public void addHandler(ExcelAntHandlerTask handler) {
        this.testTasks.add(handler);
    }

    private void addSetter(ExcelAntSet setter) {
        this.testTasks.add(setter);
    }

    public void addEvaluate(ExcelAntEvaluateCell evaluator) {
        this.testTasks.add(evaluator);
    }

    protected LinkedList<ExcelAntEvaluateCell> getEvaluators() {
        return this.evaluators;
    }

    public void execute() throws BuildException {
        Iterator taskIt = this.testTasks.iterator();
        int testCount = this.evaluators.size();
        int failureCount = 0;
        while (taskIt.hasNext()) {
            Task task = (Task)taskIt.next();
            if (task instanceof ExcelAntSet) {
                ExcelAntSet set = (ExcelAntSet)task;
                set.setWorkbookUtil(this.workbookUtil);
                set.execute();
            }
            if (task instanceof ExcelAntHandlerTask) {
                ExcelAntHandlerTask handler = (ExcelAntHandlerTask)task;
                handler.setEAWorkbookUtil(this.workbookUtil);
                handler.execute();
            }
            if (!(task instanceof ExcelAntEvaluateCell)) continue;
            ExcelAntEvaluateCell eval = (ExcelAntEvaluateCell)task;
            eval.setWorkbookUtil(this.workbookUtil);
            if (this.globalPrecision > 0.0) {
                this.log("setting globalPrecision to " + this.globalPrecision + " in the evaluator", 3);
                eval.setGlobalPrecision(this.globalPrecision);
            }
            try {
                eval.execute();
                ExcelAntEvaluationResult result = eval.getResult();
                Supplier<String> details = () -> result.getCellName() + ".  It evaluated to " + result.getReturnValue() + " when the value of " + eval.getExpectedValue() + " with precision of " + eval.getPrecision();
                if (result.didTestPass() && !result.evaluationCompleteWithError()) {
                    if (!this.showSuccessDetails) continue;
                    this.log("Succeeded when evaluating " + details.get(), 2);
                    continue;
                }
                if (this.showFailureDetail) {
                    this.failureMessages.add("\tFailed to evaluate cell " + details.get() + " was expected.");
                }
                this.passed = false;
                ++failureCount;
                if (!eval.requiredToPass()) continue;
                throw new BuildException("\tFailed to evaluate cell " + details.get() + " was expected.");
            }
            catch (NullPointerException npe) {
                this.log("Cell assignment " + eval.getCell() + " in test " + this.getName() + " appears to point to an empy cell.  Please check the  reference in the ant script.", 0);
            }
        }
        if (!this.passed) {
            this.log("Test named " + this.name + " failed because " + failureCount + " of " + testCount + " evaluations failed to evaluate correctly.", 0);
            if (this.showFailureDetail && this.failureMessages.size() > 0) {
                for (String failureMessage : this.failureMessages) {
                    this.log(failureMessage, 0);
                }
            }
        }
    }

    public boolean didTestPass() {
        return this.passed;
    }
}

