/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.util.HashMap;
import java.util.Map;

public enum BreakType {
    PAGE(1),
    COLUMN(2),
    TEXT_WRAPPING(3);

    private static Map<Integer, BreakType> imap;
    private final int value;

    private BreakType(int val) {
        this.value = val;
    }

    public static BreakType valueOf(int type) {
        BreakType bType = imap.get(new Integer(type));
        if (bType == null) {
            throw new IllegalArgumentException("Unknown break type: " + type);
        }
        return bType;
    }

    public int getValue() {
        return this.value;
    }

    static {
        imap = new HashMap<Integer, BreakType>();
        for (BreakType p : BreakType.values()) {
            imap.put(new Integer(p.getValue()), p);
        }
    }
}

