/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class EvilUnclosedBRFixingInputStream
extends InputStream {
    private InputStream source;
    private byte[] spare;
    private static byte[] detect = new byte[]{60, 98, 114, 62};

    public EvilUnclosedBRFixingInputStream(InputStream source) {
        this.source = source;
    }

    @Override
    public int read() throws IOException {
        return this.source.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        int readA = this.readFromSpare(b, off, len);
        int readB = this.source.read(b, off + readA, len - readA);
        if (readB == -1 || readB == 0) {
            if (readA == 0) {
                return readB;
            }
            read = readA;
        } else {
            read = readA + readB;
        }
        if (read > 0) {
            read = this.fixUp(b, off, read);
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private int readFromSpare(byte[] b, int offset, int len) {
        if (this.spare == null) {
            return 0;
        }
        if (len == 0) {
            throw new IllegalArgumentException("Asked to read 0 bytes");
        }
        if (this.spare.length <= len) {
            System.arraycopy(this.spare, 0, b, offset, this.spare.length);
            int read = this.spare.length;
            this.spare = null;
            return read;
        }
        byte[] newspare = new byte[this.spare.length - len];
        System.arraycopy(this.spare, 0, b, offset, len);
        System.arraycopy(this.spare, len, newspare, 0, newspare.length);
        this.spare = newspare;
        return len;
    }

    private void addToSpare(byte[] b, int offset, int len, boolean atTheEnd) {
        if (this.spare == null) {
            this.spare = new byte[len];
            System.arraycopy(b, offset, this.spare, 0, len);
        } else {
            byte[] newspare = new byte[this.spare.length + len];
            if (atTheEnd) {
                System.arraycopy(this.spare, 0, newspare, 0, this.spare.length);
                System.arraycopy(b, offset, newspare, this.spare.length, len);
            } else {
                System.arraycopy(b, offset, newspare, 0, len);
                System.arraycopy(this.spare, 0, newspare, len, this.spare.length);
            }
            this.spare = newspare;
        }
    }

    private int fixUp(byte[] b, int offset, int read) {
        int j;
        boolean going;
        for (int i = 0; i < detect.length - 1; ++i) {
            int base = offset + read - 1 - i;
            if (base < 0) continue;
            going = true;
            for (j = 0; j <= i && going; ++j) {
                if (b[base + j] == detect[j]) continue;
                going = false;
            }
            if (!going) continue;
            this.addToSpare(b, base, i + 1, true);
            --read;
            read -= i;
            break;
        }
        ArrayList<Integer> fixAt = new ArrayList<Integer>();
        for (int i = offset; i <= offset + read - detect.length; ++i) {
            going = true;
            for (j = 0; j < detect.length && going; ++j) {
                if (b[i + j] == detect[j]) continue;
                going = false;
            }
            if (!going) continue;
            fixAt.add(i);
        }
        if (fixAt.size() == 0) {
            return read;
        }
        int needed = offset + read + fixAt.size();
        int overshoot = needed - b.length;
        if (overshoot > 0) {
            int fixes = 0;
            Iterator i$ = fixAt.iterator();
            while (i$.hasNext()) {
                int at = (Integer)i$.next();
                if (at > offset + read - detect.length - overshoot - fixes) {
                    overshoot = needed - at - 1 - fixes;
                    break;
                }
                ++fixes;
            }
            this.addToSpare(b, offset + read - overshoot, overshoot, false);
            read -= overshoot;
        }
        for (j = fixAt.size() - 1; j >= 0; --j) {
            int i = (Integer)fixAt.get(j);
            if (i >= read + offset || i > read - 3) continue;
            byte[] tmp = new byte[read - i - 3];
            System.arraycopy(b, i + 3, tmp, 0, tmp.length);
            b[i + 3] = 47;
            System.arraycopy(tmp, 0, b, i + 4, tmp.length);
            ++read;
        }
        return read;
    }
}

