/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import org.apache.poi.POIXMLDocumentPart;

public abstract class POIXMLRelation {
    private String _type;
    private String _relation;
    private String _defaultName;
    private Class<? extends POIXMLDocumentPart> _cls;

    public POIXMLRelation(String type, String rel, String defaultName, Class<? extends POIXMLDocumentPart> cls) {
        this._type = type;
        this._relation = rel;
        this._defaultName = defaultName;
        this._cls = cls;
    }

    public POIXMLRelation(String type, String rel, String defaultName) {
        this(type, rel, defaultName, null);
    }

    public String getContentType() {
        return this._type;
    }

    public String getRelation() {
        return this._relation;
    }

    public String getDefaultFileName() {
        return this._defaultName;
    }

    public String getFileName(int index) {
        if (this._defaultName.indexOf("#") == -1) {
            return this.getDefaultFileName();
        }
        return this._defaultName.replace("#", Integer.toString(index));
    }

    public Integer getFileNameIndex(POIXMLDocumentPart part) {
        String regex = this._defaultName.replace("#", "(\\d+)");
        return Integer.valueOf(part.getPackagePart().getPartName().getName().replaceAll(regex, "$1"));
    }

    public Class<? extends POIXMLDocumentPart> getRelationClass() {
        return this._cls;
    }
}

