/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.util;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.SuppressForbidden;

public class ZipSecureFile
extends ZipFile {
    private static final POILogger LOG = POILogFactory.getLogger(ZipSecureFile.class);
    private static double MIN_INFLATE_RATIO = 0.01;
    private static long MAX_ENTRY_SIZE = 0xFFFFFFFFL;
    private static final long GRACE_ENTRY_SIZE = 102400L;
    private static long MAX_TEXT_SIZE = 0xA00000L;

    public static void setMinInflateRatio(double ratio) {
        MIN_INFLATE_RATIO = ratio;
    }

    public static double getMinInflateRatio() {
        return MIN_INFLATE_RATIO;
    }

    public static void setMaxEntrySize(long maxEntrySize) {
        if (maxEntrySize < 0L || maxEntrySize > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Max entry size is bounded [0-4GB], but had " + maxEntrySize);
        }
        MAX_ENTRY_SIZE = maxEntrySize;
    }

    public static long getMaxEntrySize() {
        return MAX_ENTRY_SIZE;
    }

    public static void setMaxTextSize(long maxTextSize) {
        if (maxTextSize < 0L || maxTextSize > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Max text size is bounded [0-4GB], but had " + maxTextSize);
        }
        MAX_TEXT_SIZE = maxTextSize;
    }

    public static long getMaxTextSize() {
        return MAX_TEXT_SIZE;
    }

    public ZipSecureFile(File file, int mode) throws ZipException, IOException {
        super(file, mode);
    }

    public ZipSecureFile(File file) throws ZipException, IOException {
        super(file);
    }

    public ZipSecureFile(String name) throws ZipException, IOException {
        super(name);
    }

    @Override
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        InputStream zipIS = super.getInputStream(entry);
        return ZipSecureFile.addThreshold(zipIS);
    }

    public static ThresholdInputStream addThreshold(final InputStream zipIS) throws IOException {
        ThresholdInputStream newInner = zipIS instanceof InflaterInputStream ? AccessController.doPrivileged(new PrivilegedAction<ThresholdInputStream>(){

            @Override
            @SuppressForbidden(value="TODO: Fix this to not use reflection (it will break in Java 9)! Better would be to wrap *before* instead of trying to insert wrapper afterwards.")
            public ThresholdInputStream run() {
                try {
                    Field f = FilterInputStream.class.getDeclaredField("in");
                    f.setAccessible(true);
                    InputStream oldInner = (InputStream)f.get(zipIS);
                    ThresholdInputStream newInner2 = new ThresholdInputStream(oldInner, null);
                    f.set(zipIS, newInner2);
                    return newInner2;
                }
                catch (Exception ex) {
                    LOG.log(5, new Object[]{"SecurityManager doesn't allow manipulation via reflection for zipbomb detection - continue with original input stream", ex});
                    return null;
                }
            }
        }) : null;
        return new ThresholdInputStream(zipIS, newInner);
    }

    public static class ThresholdInputStream
    extends PushbackInputStream {
        long counter = 0L;
        ThresholdInputStream cis;

        public ThresholdInputStream(InputStream is, ThresholdInputStream cis) {
            super(is, 1);
            this.cis = cis;
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b > -1) {
                this.advance(1);
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int cnt = this.in.read(b, off, len);
            if (cnt > -1) {
                this.advance(cnt);
            }
            return cnt;
        }

        @Override
        public long skip(long n) throws IOException {
            this.counter = 0L;
            return this.in.skip(n);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.counter = 0L;
            this.in.reset();
        }

        public void advance(int advance) throws IOException {
            this.counter += (long)advance;
            if (this.counter > MAX_ENTRY_SIZE) {
                throw new IOException("Zip bomb detected! The file would exceed the max size of the expanded data in the zip-file. This may indicates that the file is used to inflate memory usage and thus could pose a security risk. You can adjust this limit via ZipSecureFile.setMaxEntrySize() if you need to work with files which are very large. Counter: " + this.counter + ", cis.counter: " + (this.cis == null ? 0L : this.cis.counter) + "Limits: MAX_ENTRY_SIZE: " + MAX_ENTRY_SIZE);
            }
            if (this.cis == null) {
                return;
            }
            if (this.counter <= 102400L) {
                return;
            }
            double ratio = (double)this.cis.counter / (double)this.counter;
            if (ratio >= MIN_INFLATE_RATIO) {
                return;
            }
            throw new IOException("Zip bomb detected! The file would exceed the max. ratio of compressed file size to the size of the expanded data. This may indicate that the file is used to inflate memory usage and thus could pose a security risk. You can adjust this limit via ZipSecureFile.setMinInflateRatio() if you need to work with files which exceed this limit. Counter: " + this.counter + ", cis.counter: " + this.cis.counter + ", ratio: " + (double)this.cis.counter / (double)this.counter + "Limits: MIN_INFLATE_RATIO: " + MIN_INFLATE_RATIO);
        }

        public ZipEntry getNextEntry() throws IOException {
            if (!(this.in instanceof ZipInputStream)) {
                throw new UnsupportedOperationException("underlying stream is not a ZipInputStream");
            }
            this.counter = 0L;
            return ((ZipInputStream)this.in).getNextEntry();
        }

        public void closeEntry() throws IOException {
            if (!(this.in instanceof ZipInputStream)) {
                throw new UnsupportedOperationException("underlying stream is not a ZipInputStream");
            }
            this.counter = 0L;
            ((ZipInputStream)this.in).closeEntry();
        }

        @Override
        public void unread(int b) throws IOException {
            if (!(this.in instanceof PushbackInputStream)) {
                throw new UnsupportedOperationException("underlying stream is not a PushbackInputStream");
            }
            if (--this.counter < 0L) {
                this.counter = 0L;
            }
            ((PushbackInputStream)this.in).unread(b);
        }

        @Override
        public void unread(byte[] b, int off, int len) throws IOException {
            if (!(this.in instanceof PushbackInputStream)) {
                throw new UnsupportedOperationException("underlying stream is not a PushbackInputStream");
            }
            this.counter -= (long)len;
            if (--this.counter < 0L) {
                this.counter = 0L;
            }
            ((PushbackInputStream)this.in).unread(b, off, len);
        }

        @Override
        @SuppressForbidden(value="just delegating")
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public boolean markSupported() {
            return this.in.markSupported();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
        }
    }
}

