/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.apache.poi.util.Internal;
import org.apache.poi.xwpf.usermodel.BreakClear;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.VerticalAlign;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSignedHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalAlignRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBrClear;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBrType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalAlignRun;

public class XWPFRun {
    private CTR run;
    private XWPFParagraph paragraph;

    public XWPFRun(CTR r, XWPFParagraph p) {
        this.run = r;
        this.paragraph = p;
    }

    @Internal
    public CTR getCTR() {
        return this.run;
    }

    public XWPFParagraph getParagraph() {
        return this.paragraph;
    }

    public boolean isBold() {
        CTRPr pr = this.run.getRPr();
        return pr != null && pr.isSetB();
    }

    public void setBold(boolean value) {
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff bold = pr.isSetB() ? pr.getB() : pr.addNewB();
        bold.setVal(value ? STOnOff.TRUE : STOnOff.FALSE);
    }

    public String getText(int pos) {
        return this.run.sizeOfTArray() == 0 ? null : this.run.getTArray(pos).getStringValue();
    }

    public void setText(String value) {
        this.setText(value, this.run.getTList().size());
    }

    public void setText(String value, int pos) {
        if (pos > this.run.sizeOfTArray()) {
            throw new ArrayIndexOutOfBoundsException("Value too large for the parameter position in XWPFRun.setText(String value,int pos)");
        }
        CTText t = pos < this.run.sizeOfTArray() && pos >= 0 ? this.run.getTArray(pos) : this.run.addNewT();
        t.setStringValue(value);
        XWPFRun.preserveSpaces((XmlString)t);
    }

    public boolean isItalic() {
        CTRPr pr = this.run.getRPr();
        return pr != null && pr.isSetI();
    }

    public void setItalic(boolean value) {
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff italic = pr.isSetI() ? pr.getI() : pr.addNewI();
        italic.setVal(value ? STOnOff.TRUE : STOnOff.FALSE);
    }

    public UnderlinePatterns getUnderline() {
        CTRPr pr = this.run.getRPr();
        return pr != null && pr.isSetU() ? UnderlinePatterns.valueOf(pr.getU().getVal().intValue()) : UnderlinePatterns.NONE;
    }

    public void setUnderline(UnderlinePatterns value) {
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTUnderline underline = pr.getU() == null ? pr.addNewU() : pr.getU();
        underline.setVal(STUnderline.Enum.forInt((int)value.getValue()));
    }

    public boolean isStrike() {
        CTRPr pr = this.run.getRPr();
        return pr != null && pr.isSetStrike();
    }

    public void setStrike(boolean value) {
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff strike = pr.isSetStrike() ? pr.getStrike() : pr.addNewStrike();
        strike.setVal(value ? STOnOff.TRUE : STOnOff.FALSE);
    }

    public VerticalAlign getSubscript() {
        CTRPr pr = this.run.getRPr();
        return pr != null && pr.isSetVertAlign() ? VerticalAlign.valueOf(pr.getVertAlign().getVal().intValue()) : VerticalAlign.BASELINE;
    }

    public void setSubscript(VerticalAlign valign) {
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTVerticalAlignRun ctValign = pr.isSetVertAlign() ? pr.getVertAlign() : pr.addNewVertAlign();
        ctValign.setVal(STVerticalAlignRun.Enum.forInt((int)valign.getValue()));
    }

    public String getFontFamily() {
        CTRPr pr = this.run.getRPr();
        return pr != null && pr.isSetRFonts() ? pr.getRFonts().getAscii() : null;
    }

    public void setFontFamily(String fontFamily) {
        CTRPr pr = this.run.getRPr();
        CTFonts fonts = pr.isSetRFonts() ? pr.getRFonts() : pr.addNewRFonts();
        fonts.setAscii(fontFamily);
    }

    public int getFontSize() {
        CTRPr pr = this.run.getRPr();
        return pr != null && pr.isSetSz() ? pr.getSz().getVal().divide(new BigInteger("2")).intValue() : -1;
    }

    public void setFontSize(int size) {
        BigInteger bint = new BigInteger("" + size);
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTHpsMeasure ctSize = pr.isSetSz() ? pr.getSz() : pr.addNewSz();
        ctSize.setVal(bint.multiply(new BigInteger("2")));
    }

    public int getTextPosition() {
        CTRPr pr = this.run.getRPr();
        return pr != null && pr.isSetPosition() ? pr.getPosition().getVal().intValue() : -1;
    }

    public void setTextPosition(int val) {
        BigInteger bint = new BigInteger("" + val);
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTSignedHpsMeasure position = pr.isSetPosition() ? pr.getPosition() : pr.addNewPosition();
        position.setVal(bint);
    }

    public void removeBreak() {
    }

    public void addBreak() {
        this.run.addNewBr();
    }

    public void addBreak(BreakType type) {
        CTBr br = this.run.addNewBr();
        br.setType(STBrType.Enum.forInt((int)type.getValue()));
    }

    public void addBreak(BreakClear clear) {
        CTBr br = this.run.addNewBr();
        br.setType(STBrType.Enum.forInt((int)BreakType.TEXT_WRAPPING.getValue()));
        br.setClear(STBrClear.Enum.forInt((int)clear.getValue()));
    }

    public void addCarriageReturn() {
        this.run.addNewCr();
    }

    public void removeCarriageReturn() {
    }

    static void preserveSpaces(XmlString xs) {
        String text = xs.getStringValue();
        if (text != null && (text.startsWith(" ") || text.endsWith(" "))) {
            XmlCursor c = xs.newCursor();
            c.toNextToken();
            c.insertAttributeWithValue(new QName("http://www.w3.org/XML/1998/namespace", "space"), "preserve");
            c.dispose();
        }
    }
}

