/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.poi.hslf.usermodel.PictureData;

public abstract class Bitmap
extends PictureData {
    @Override
    public byte[] getData() {
        byte[] rawdata = this.getRawData();
        int prefixLen = 16 * this.uidInstanceCount + 1;
        byte[] imgdata = new byte[rawdata.length - prefixLen];
        System.arraycopy(rawdata, prefixLen, imgdata, 0, imgdata.length);
        return imgdata;
    }

    @Override
    public void setData(byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < this.uidInstanceCount; ++i) {
            byte[] checksum = Bitmap.getChecksum(data);
            out.write(checksum);
        }
        out.write(0);
        out.write(data);
        this.setRawData(out.toByteArray());
    }
}

