/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherArrayProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hslf.usermodel.HSLFAutoShape;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFLine;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFShapeContainer;
import org.apache.poi.hslf.usermodel.HSLFSheet;
import org.apache.poi.hslf.usermodel.HSLFTableCell;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.TableShape;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.Units;

public final class HSLFTable
extends HSLFGroupShape
implements HSLFShapeContainer,
TableShape<HSLFShape, HSLFTextParagraph> {
    protected static final int BORDER_TOP = 1;
    protected static final int BORDER_RIGHT = 2;
    protected static final int BORDER_BOTTOM = 3;
    protected static final int BORDER_LEFT = 4;
    protected static final int BORDERS_ALL = 5;
    protected static final int BORDERS_OUTSIDE = 6;
    protected static final int BORDERS_INSIDE = 7;
    protected static final int BORDERS_NONE = 8;
    protected HSLFTableCell[][] cells;

    public HSLFTable(int numRows, int numCols) {
        this(numRows, numCols, null);
    }

    public HSLFTable(int numRows, int numCols, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(parent);
        if (numRows < 1) {
            throw new IllegalArgumentException("The number of rows must be greater than 1");
        }
        if (numCols < 1) {
            throw new IllegalArgumentException("The number of columns must be greater than 1");
        }
        int x = 0;
        int y = 0;
        int tblWidth = 0;
        int tblHeight = 0;
        this.cells = new HSLFTableCell[numRows][numCols];
        for (int i = 0; i < this.cells.length; ++i) {
            x = 0;
            for (int j = 0; j < this.cells[i].length; ++j) {
                this.cells[i][j] = new HSLFTableCell(this);
                Rectangle anchor = new Rectangle(x, y, 100, 40);
                this.cells[i][j].setAnchor(anchor);
                x += 100;
            }
            y += 40;
        }
        tblWidth = x;
        tblHeight = y;
        this.setAnchor(new Rectangle(0, 0, tblWidth, tblHeight));
        EscherContainerRecord spCont = (EscherContainerRecord)this.getSpContainer().getChild(0);
        EscherOptRecord opt = new EscherOptRecord();
        opt.setRecordId((short)-3806);
        opt.addEscherProperty((EscherProperty)new EscherSimpleProperty(927, 1));
        EscherArrayProperty p = new EscherArrayProperty(17312, false, null);
        p.setSizeOfElements(4);
        p.setNumberOfElementsInArray(numRows);
        p.setNumberOfElementsInMemory(numRows);
        opt.addEscherProperty((EscherProperty)p);
        spCont.addChildBefore((EscherRecord)opt, 61456);
    }

    public HSLFTable(EscherContainerRecord escherRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(escherRecord, parent);
    }

    public HSLFTableCell getCell(int row, int col) {
        return this.cells[row][col];
    }

    public int getNumberOfColumns() {
        return this.cells[0].length;
    }

    public int getNumberOfRows() {
        return this.cells.length;
    }

    @Override
    protected void afterInsert(HSLFSheet sh) {
        super.afterInsert(sh);
        EscherContainerRecord spCont = (EscherContainerRecord)this.getSpContainer().getChild(0);
        List lst = spCont.getChildRecords();
        AbstractEscherOptRecord opt = (AbstractEscherOptRecord)lst.get(lst.size() - 2);
        EscherArrayProperty p = (EscherArrayProperty)opt.lookup(928);
        for (int i = 0; i < this.cells.length; ++i) {
            HSLFTableCell cell = this.cells[i][0];
            int rowHeight = Units.pointsToMaster((double)cell.getAnchor().height);
            byte[] val = new byte[4];
            LittleEndian.putInt((byte[])val, (int)0, (int)rowHeight);
            p.setElement(i, val);
            for (int j = 0; j < this.cells[i].length; ++j) {
                HSLFLine bl;
                HSLFLine bb;
                HSLFLine br;
                HSLFTableCell c = this.cells[i][j];
                this.addShape(c);
                HSLFLine bt = c.getBorderTop();
                if (bt != null) {
                    this.addShape(bt);
                }
                if ((br = c.getBorderRight()) != null) {
                    this.addShape(br);
                }
                if ((bb = c.getBorderBottom()) != null) {
                    this.addShape(bb);
                }
                if ((bl = c.getBorderLeft()) == null) continue;
                this.addShape(bl);
            }
        }
    }

    protected void initTable() {
        List<HSLFShape> shapeList = this.getShapes();
        Iterator<HSLFShape> shapeIter = shapeList.iterator();
        while (shapeIter.hasNext()) {
            HSLFAutoShape autoShape;
            EscherTextboxRecord etr;
            HSLFShape shape = shapeIter.next();
            if (shape instanceof HSLFAutoShape && (etr = (EscherTextboxRecord)(autoShape = (HSLFAutoShape)shape).getEscherChild(-4083)) != null) continue;
            shapeIter.remove();
        }
        Collections.sort(shapeList, new Comparator<HSLFShape>(){

            @Override
            public int compare(HSLFShape o1, HSLFShape o2) {
                Rectangle anchor1 = o1.getAnchor();
                Rectangle anchor2 = o2.getAnchor();
                int delta = anchor1.y - anchor2.y;
                if (delta == 0) {
                    delta = anchor1.x - anchor2.x;
                }
                if (delta == 0) {
                    delta = anchor2.width * anchor2.height - anchor1.width * anchor1.height;
                }
                return delta;
            }
        });
        int y0 = shapeList.isEmpty() ? -1 : shapeList.get((int)0).getAnchor().y - 1;
        int maxrowlen = 0;
        ArrayList lst = new ArrayList();
        ArrayList<HSLFShape> row = null;
        for (HSLFShape sh : shapeList) {
            if (!(sh instanceof HSLFTextShape)) continue;
            Rectangle anchor = sh.getAnchor();
            if (anchor.y != y0) {
                y0 = anchor.y;
                row = new ArrayList<HSLFShape>();
                lst.add(row);
            }
            row.add(sh);
            maxrowlen = Math.max(maxrowlen, row.size());
        }
        this.cells = new HSLFTableCell[lst.size()][maxrowlen];
        for (int i = 0; i < lst.size(); ++i) {
            row = (List)lst.get(i);
            for (int j = 0; j < row.size(); ++j) {
                HSLFTextShape tx = (HSLFTextShape)row.get(j);
                this.cells[i][j] = new HSLFTableCell(tx.getSpContainer(), this.getParent());
                this.cells[i][j].setSheet(tx.getSheet());
            }
        }
    }

    @Override
    public void setSheet(HSLFSheet sheet) {
        super.setSheet(sheet);
        if (this.cells == null) {
            this.initTable();
        }
    }

    public void setRowHeight(int row, int height) {
        int currentHeight = this.cells[row][0].getAnchor().height;
        int dy = height - currentHeight;
        for (int i = row; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                Rectangle anchor = this.cells[i][j].getAnchor();
                if (i == row) {
                    anchor.height = height;
                } else {
                    anchor.y += dy;
                }
                this.cells[i][j].setAnchor(anchor);
            }
        }
        Rectangle tblanchor = this.getAnchor();
        tblanchor.height += dy;
        this.setAnchor(tblanchor);
    }

    public void setColumnWidth(int col, int width) {
        int currentWidth = this.cells[0][col].getAnchor().width;
        int dx = width - currentWidth;
        for (int i = 0; i < this.cells.length; ++i) {
            Rectangle anchor = this.cells[i][col].getAnchor();
            anchor.width = width;
            this.cells[i][col].setAnchor(anchor);
            if (col >= this.cells[i].length - 1) continue;
            for (int j = col + 1; j < this.cells[i].length; ++j) {
                anchor = this.cells[i][j].getAnchor();
                anchor.x += dx;
                this.cells[i][j].setAnchor(anchor);
            }
        }
        Rectangle tblanchor = this.getAnchor();
        tblanchor.width += dx;
        this.setAnchor(tblanchor);
    }

    public void setAllBorders(HSLFLine line) {
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                HSLFTableCell cell = this.cells[i][j];
                cell.setBorderTop(this.cloneBorder(line));
                cell.setBorderLeft(this.cloneBorder(line));
                if (j == this.cells[i].length - 1) {
                    cell.setBorderRight(this.cloneBorder(line));
                }
                if (i != this.cells.length - 1) continue;
                cell.setBorderBottom(this.cloneBorder(line));
            }
        }
    }

    public void setOutsideBorders(HSLFLine line) {
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                HSLFTableCell cell = this.cells[i][j];
                if (j == 0) {
                    cell.setBorderLeft(this.cloneBorder(line));
                }
                if (j == this.cells[i].length - 1) {
                    cell.setBorderRight(this.cloneBorder(line));
                } else {
                    cell.setBorderLeft(null);
                    cell.setBorderLeft(null);
                }
                if (i == 0) {
                    cell.setBorderTop(this.cloneBorder(line));
                    continue;
                }
                if (i == this.cells.length - 1) {
                    cell.setBorderBottom(this.cloneBorder(line));
                    continue;
                }
                cell.setBorderTop(null);
                cell.setBorderBottom(null);
            }
        }
    }

    public void setInsideBorders(HSLFLine line) {
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                HSLFTableCell cell = this.cells[i][j];
                if (j != this.cells[i].length - 1) {
                    cell.setBorderRight(this.cloneBorder(line));
                } else {
                    cell.setBorderLeft(null);
                    cell.setBorderLeft(null);
                }
                if (i != this.cells.length - 1) {
                    cell.setBorderBottom(this.cloneBorder(line));
                    continue;
                }
                cell.setBorderTop(null);
                cell.setBorderBottom(null);
            }
        }
    }

    private HSLFLine cloneBorder(HSLFLine line) {
        HSLFLine border = this.createBorder();
        border.setLineWidth(line.getLineWidth());
        border.setLineDashing(line.getLineDashing());
        border.setLineColor(line.getLineColor());
        border.setLineCompound(line.getLineCompound());
        return border;
    }

    public HSLFLine createBorder() {
        HSLFLine line = new HSLFLine(this);
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFTable.setEscherProperty(opt, (short)324, -1);
        HSLFTable.setEscherProperty(opt, (short)383, -1);
        HSLFTable.setEscherProperty(opt, (short)575, 131072);
        HSLFTable.setEscherProperty(opt, (short)703, 524288);
        return line;
    }
}

