/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.LittleEndian;

public final class TextRulerAtom
extends RecordAtom {
    private byte[] _header;
    private byte[] _data;
    private int defaultTabSize;
    private int numLevels;
    private int[] tabStops;
    private int[] bulletOffsets = new int[5];
    private int[] textOffsets = new int[5];

    public TextRulerAtom() {
        this._header = new byte[8];
        this._data = new byte[0];
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    protected TextRulerAtom(byte[] source, int start, int len) {
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
        try {
            this.read();
        }
        catch (Exception e) {
            logger.log(7, new Object[]{"Failed to parse TextRulerAtom: " + e.getMessage()});
            e.printStackTrace();
        }
    }

    @Override
    public long getRecordType() {
        return RecordTypes.TextRulerAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    private void read() {
        int pos = 0;
        short mask = LittleEndian.getShort((byte[])this._data);
        pos += 4;
        int[] bits = new int[]{1, 0, 2, 3, 8, 4, 9, 5, 10, 6, 11, 7, 12};
        block7: for (int i = 0; i < bits.length; ++i) {
            if ((mask & 1 << bits[i]) == 0) continue;
            switch (bits[i]) {
                case 0: {
                    this.defaultTabSize = LittleEndian.getShort((byte[])this._data, (int)pos);
                    pos += 2;
                    continue block7;
                }
                case 1: {
                    this.numLevels = LittleEndian.getShort((byte[])this._data, (int)pos);
                    pos += 2;
                    continue block7;
                }
                case 2: {
                    short val = LittleEndian.getShort((byte[])this._data, (int)pos);
                    pos += 2;
                    this.tabStops = new int[val * 2];
                    for (int j = 0; j < this.tabStops.length; ++j) {
                        this.tabStops[j] = LittleEndian.getUShort((byte[])this._data, (int)pos);
                        pos += 2;
                    }
                    continue block7;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    short val = LittleEndian.getShort((byte[])this._data, (int)pos);
                    pos += 2;
                    this.bulletOffsets[bits[i] - 3] = val;
                    continue block7;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    short val = LittleEndian.getShort((byte[])this._data, (int)pos);
                    pos += 2;
                    this.textOffsets[bits[i] - 8] = val;
                    continue block7;
                }
            }
        }
    }

    public int getDefaultTabSize() {
        return this.defaultTabSize;
    }

    public int getNumberOfLevels() {
        return this.numLevels;
    }

    public int[] getTabStops() {
        return this.tabStops;
    }

    public int[] getTextOffsets() {
        return this.textOffsets;
    }

    public int[] getBulletOffsets() {
        return this.bulletOffsets;
    }

    public static TextRulerAtom getParagraphInstance() {
        byte[] data = new byte[]{0, 0, -90, 15, 10, 0, 0, 0, 16, 3, 0, 0, -7, 0, 65, 1, 65, 1};
        TextRulerAtom ruler = new TextRulerAtom(data, 0, data.length);
        return ruler;
    }

    public void setParagraphIndent(short tetxOffset, short bulletOffset) {
        LittleEndian.putShort((byte[])this._data, (int)4, (short)tetxOffset);
        LittleEndian.putShort((byte[])this._data, (int)6, (short)bulletOffset);
        LittleEndian.putShort((byte[])this._data, (int)8, (short)bulletOffset);
    }
}

