/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherPropertyFactory;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hslf.model.MovieShape;
import org.apache.poi.hslf.model.OLEShape;
import org.apache.poi.hslf.record.InteractiveInfo;
import org.apache.poi.hslf.record.OEShapeAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.usermodel.HSLFAutoShape;
import org.apache.poi.hslf.usermodel.HSLFFreeformShape;
import org.apache.poi.hslf.usermodel.HSLFGroupShape;
import org.apache.poi.hslf.usermodel.HSLFLine;
import org.apache.poi.hslf.usermodel.HSLFPictureShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFTable;
import org.apache.poi.hslf.usermodel.HSLFTableCell;
import org.apache.poi.hslf.usermodel.HSLFTextBox;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class HSLFShapeFactory {
    protected static final POILogger logger = POILogFactory.getLogger(HSLFShapeFactory.class);

    public static HSLFShape createShape(EscherContainerRecord spContainer, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        if (spContainer.getRecordId() == -4093) {
            return HSLFShapeFactory.createShapeGroup(spContainer, parent);
        }
        return HSLFShapeFactory.createSimpleShape(spContainer, parent);
    }

    public static HSLFGroupShape createShapeGroup(EscherContainerRecord spContainer, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        boolean isTable = false;
        EscherContainerRecord ecr = (EscherContainerRecord)spContainer.getChild(0);
        Object opt = HSLFShape.getEscherChild(ecr, -3806);
        if (opt != null) {
            EscherPropertyFactory f = new EscherPropertyFactory();
            List props = f.createProperties(opt.serialize(), 8, opt.getInstance());
            for (EscherProperty ep : props) {
                if (ep.getPropertyNumber() != 927 || !(ep instanceof EscherSimpleProperty) || (((EscherSimpleProperty)ep).getPropertyValue() & 1) != 1) continue;
                isTable = true;
                break;
            }
        }
        HSLFGroupShape group = isTable ? new HSLFTable(spContainer, parent) : new HSLFGroupShape(spContainer, parent);
        return group;
    }

    public static HSLFShape createSimpleShape(EscherContainerRecord spContainer, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        HSLFShape shape = null;
        EscherSpRecord spRecord = (EscherSpRecord)spContainer.getChildById((short)-4086);
        ShapeType type = ShapeType.forId((int)spRecord.getShapeType(), (boolean)false);
        switch (type) {
            case TEXT_BOX: {
                shape = new HSLFTextBox(spContainer, parent);
                break;
            }
            case HOST_CONTROL: 
            case FRAME: {
                shape = HSLFShapeFactory.createFrame(spContainer, parent);
                break;
            }
            case LINE: {
                shape = new HSLFLine(spContainer, parent);
                break;
            }
            case NOT_PRIMITIVE: {
                shape = HSLFShapeFactory.createNonPrimitive(spContainer, parent);
                break;
            }
            default: {
                EscherTextboxRecord etr = (EscherTextboxRecord)spContainer.getChildById((short)-4083);
                shape = parent instanceof HSLFTable && etr != null ? new HSLFTableCell(spContainer, (HSLFTable)parent) : new HSLFAutoShape(spContainer, parent);
            }
        }
        return shape;
    }

    private static HSLFShape createFrame(EscherContainerRecord spContainer, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        OEShapeAtom oes;
        InteractiveInfo info = (InteractiveInfo)HSLFShapeFactory.getClientDataRecord(spContainer, RecordTypes.InteractiveInfo.typeID);
        if (info != null && info.getInteractiveInfoAtom() != null) {
            switch (info.getInteractiveInfoAtom().getAction()) {
                case 5: {
                    return new OLEShape(spContainer, parent);
                }
                case 6: {
                    return new MovieShape(spContainer, parent);
                }
            }
        }
        if ((oes = (OEShapeAtom)HSLFShapeFactory.getClientDataRecord(spContainer, RecordTypes.OEShapeAtom.typeID)) != null) {
            return new OLEShape(spContainer, parent);
        }
        return new HSLFPictureShape(spContainer, parent);
    }

    private static HSLFShape createNonPrimitive(EscherContainerRecord spContainer, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        AbstractEscherOptRecord opt = (AbstractEscherOptRecord)HSLFShape.getEscherChild(spContainer, -4085);
        Object prop = HSLFShape.getEscherProperty(opt, 325);
        if (prop != null) {
            return new HSLFFreeformShape(spContainer, parent);
        }
        logger.log(3, new Object[]{"Creating AutoShape for a NotPrimitive shape"});
        return new HSLFAutoShape(spContainer, parent);
    }

    protected static <T extends Record> T getClientDataRecord(EscherContainerRecord spContainer, int recordType) {
        Iterator it = spContainer.getChildIterator();
        while (it.hasNext()) {
            EscherRecord obj = (EscherRecord)it.next();
            if (obj.getRecordId() != -4079) continue;
            byte[] data = obj.serialize();
            for (Record r : Record.findChildRecords(data, 8, data.length - 8)) {
                if (r.getRecordType() != (long)recordType) continue;
                return (T)r;
            }
        }
        return null;
    }
}

