/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import org.apache.poi.ddf.AbstractEscherOptRecord;
import org.apache.poi.ddf.EscherChildAnchorRecord;
import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherClientDataRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.record.HSLFEscherRecordFactory;
import org.apache.poi.hslf.record.InteractiveInfo;
import org.apache.poi.hslf.record.InteractiveInfoAtom;
import org.apache.poi.hslf.record.OEPlaceholderAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.usermodel.HSLFHyperlink;
import org.apache.poi.hslf.usermodel.HSLFNotes;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlideMaster;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.draw.geom.CustomGeometry;
import org.apache.poi.sl.draw.geom.Guide;
import org.apache.poi.sl.draw.geom.PresetGeometries;
import org.apache.poi.sl.usermodel.LineDecoration;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.Shadow;
import org.apache.poi.sl.usermodel.ShapeContainer;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.sl.usermodel.SimpleShape;
import org.apache.poi.sl.usermodel.StrokeStyle;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.Units;

public abstract class HSLFSimpleShape
extends HSLFShape
implements SimpleShape<HSLFShape, HSLFTextParagraph> {
    public static final double DEFAULT_LINE_WIDTH = 0.75;
    protected Record[] _clientRecords;
    protected EscherClientDataRecord _clientData;

    protected HSLFSimpleShape(EscherContainerRecord escherRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> parent) {
        super(escherRecord, parent);
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean isChild) {
        EscherChildAnchorRecord anchor;
        this._escherContainer = new EscherContainerRecord();
        this._escherContainer.setRecordId((short)-4092);
        this._escherContainer.setOptions((short)15);
        EscherSpRecord sp = new EscherSpRecord();
        int flags = 2560;
        if (isChild) {
            flags |= 2;
        }
        sp.setFlags(flags);
        this._escherContainer.addChildRecord((EscherRecord)sp);
        EscherOptRecord opt = new EscherOptRecord();
        opt.setRecordId((short)-4085);
        this._escherContainer.addChildRecord((EscherRecord)opt);
        if (isChild) {
            anchor = new EscherChildAnchorRecord();
        } else {
            anchor = new EscherClientAnchorRecord();
            byte[] header = new byte[16];
            LittleEndian.putUShort((byte[])header, (int)0, (int)0);
            LittleEndian.putUShort((byte[])header, (int)2, (int)0);
            LittleEndian.putInt((byte[])header, (int)4, (int)8);
            anchor.fillFields(header, 0, null);
        }
        this._escherContainer.addChildRecord((EscherRecord)anchor);
        return this._escherContainer;
    }

    public double getLineWidth() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 459);
        double width = prop == null ? 0.75 : Units.toPoints((long)prop.getPropertyValue());
        return width;
    }

    public void setLineWidth(double width) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)459, Units.toEMU((double)width));
    }

    public void setLineColor(Color color) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        if (color == null) {
            HSLFSimpleShape.setEscherProperty(opt, (short)511, 524288);
        } else {
            int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            HSLFSimpleShape.setEscherProperty(opt, (short)448, rgb);
            HSLFSimpleShape.setEscherProperty(opt, (short)511, 0x180018);
        }
    }

    public Color getLineColor() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty p = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 511);
        if (p != null && (p.getPropertyValue() & 8) == 0) {
            return null;
        }
        Color clr = this.getColor((short)448, (short)449, -1);
        return clr == null ? Color.black : clr;
    }

    public StrokeStyle.LineCap getLineCap() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 471);
        return prop == null ? StrokeStyle.LineCap.FLAT : StrokeStyle.LineCap.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineCap(StrokeStyle.LineCap pen) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)471, pen == StrokeStyle.LineCap.FLAT ? -1 : pen.nativeId);
    }

    public StrokeStyle.LineDash getLineDash() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 462);
        return prop == null ? StrokeStyle.LineDash.SOLID : StrokeStyle.LineDash.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineDash(StrokeStyle.LineDash pen) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)462, pen == StrokeStyle.LineDash.SOLID ? -1 : pen.nativeId);
    }

    public StrokeStyle.LineCompound getLineCompound() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 461);
        return prop == null ? StrokeStyle.LineCompound.SINGLE : StrokeStyle.LineCompound.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineCompound(StrokeStyle.LineCompound style) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)461, style == StrokeStyle.LineCompound.SINGLE ? -1 : style.nativeId);
    }

    public StrokeStyle getStrokeStyle() {
        return new StrokeStyle(){

            public PaintStyle getPaint() {
                return DrawPaint.createSolidPaint((Color)HSLFSimpleShape.this.getLineColor());
            }

            public StrokeStyle.LineCap getLineCap() {
                return null;
            }

            public StrokeStyle.LineDash getLineDash() {
                return HSLFSimpleShape.this.getLineDash();
            }

            public StrokeStyle.LineCompound getLineCompound() {
                return HSLFSimpleShape.this.getLineCompound();
            }

            public double getLineWidth() {
                return HSLFSimpleShape.this.getLineWidth();
            }
        };
    }

    public Color getFillColor() {
        return this.getFill().getForegroundColor();
    }

    public void setFillColor(Color color) {
        this.getFill().setForegroundColor(color);
    }

    protected <T extends Record> T getClientDataRecord(int recordType) {
        Record[] records = this.getClientRecords();
        if (records != null) {
            for (int i = 0; i < records.length; ++i) {
                if (records[i].getRecordType() != (long)recordType) continue;
                return (T)records[i];
            }
        }
        return null;
    }

    protected Record[] getClientRecords() {
        if (this._clientData == null) {
            Object r = this.getEscherChild(-4079);
            if (r != null && !(r instanceof EscherClientDataRecord)) {
                byte[] data = r.serialize();
                r = new EscherClientDataRecord();
                r.fillFields(data, 0, (EscherRecordFactory)new HSLFEscherRecordFactory());
            }
            this._clientData = (EscherClientDataRecord)r;
        }
        if (this._clientData != null && this._clientRecords == null) {
            byte[] data = this._clientData.getRemainingData();
            this._clientRecords = Record.findChildRecords(data, 0, data.length);
        }
        return this._clientRecords;
    }

    protected void updateClientData() {
        if (this._clientData != null && this._clientRecords != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < this._clientRecords.length; ++i) {
                    this._clientRecords[i].writeOut(out);
                }
            }
            catch (Exception e) {
                throw new HSLFException(e);
            }
            this._clientData.setRemainingData(out.toByteArray());
        }
    }

    public void setHyperlink(HSLFHyperlink link) {
        if (link.getId() == -1) {
            throw new HSLFException("You must call SlideShow.addHyperlink(Hyperlink link) first");
        }
        EscherClientDataRecord cldata = new EscherClientDataRecord();
        cldata.setOptions((short)15);
        this.getSpContainer().addChildRecord((EscherRecord)cldata);
        InteractiveInfo info = new InteractiveInfo();
        InteractiveInfoAtom infoAtom = info.getInteractiveInfoAtom();
        switch (link.getType()) {
            case 2: {
                infoAtom.setAction((byte)3);
                infoAtom.setJump((byte)3);
                infoAtom.setHyperlinkType((byte)2);
                break;
            }
            case 3: {
                infoAtom.setAction((byte)3);
                infoAtom.setJump((byte)4);
                infoAtom.setHyperlinkType((byte)3);
                break;
            }
            case 0: {
                infoAtom.setAction((byte)3);
                infoAtom.setJump((byte)1);
                infoAtom.setHyperlinkType((byte)0);
                break;
            }
            case 1: {
                infoAtom.setAction((byte)3);
                infoAtom.setJump((byte)2);
                infoAtom.setHyperlinkType((byte)1);
                break;
            }
            case 8: {
                infoAtom.setAction((byte)4);
                infoAtom.setJump((byte)0);
                infoAtom.setHyperlinkType((byte)8);
                break;
            }
            case 7: {
                infoAtom.setAction((byte)4);
                infoAtom.setJump((byte)0);
                infoAtom.setHyperlinkType((byte)7);
                break;
            }
            default: {
                this.logger.log(5, new Object[]{"Ignore unknown hyperlink type : " + link.getTitle()});
            }
        }
        infoAtom.setHyperlinkID(link.getId());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            info.writeOut(out);
        }
        catch (Exception e) {
            throw new HSLFException(e);
        }
        cldata.setRemainingData(out.toByteArray());
    }

    public Guide getAdjustValue(String name) {
        short escherProp;
        if (name == null || !name.matches("adj([1-9]|10)?")) {
            throw new IllegalArgumentException("Adjust value '" + name + "' not supported.");
        }
        if ("".equals(name = name.replace("adj", ""))) {
            name = "1";
        }
        switch (Integer.parseInt(name)) {
            case 1: {
                escherProp = 327;
                break;
            }
            case 2: {
                escherProp = 328;
                break;
            }
            case 3: {
                escherProp = 329;
                break;
            }
            case 4: {
                escherProp = 330;
                break;
            }
            case 5: {
                escherProp = 331;
                break;
            }
            case 6: {
                escherProp = 332;
                break;
            }
            case 7: {
                escherProp = 333;
                break;
            }
            case 8: {
                escherProp = 334;
                break;
            }
            case 9: {
                escherProp = 335;
                break;
            }
            case 10: {
                escherProp = 336;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        int adjval = this.getEscherProperty(escherProp, -1);
        return adjval == -1 ? null : new Guide(name, "val " + adjval);
    }

    public CustomGeometry getGeometry() {
        ShapeType st;
        String name;
        PresetGeometries dict = PresetGeometries.getInstance();
        CustomGeometry geom = (CustomGeometry)dict.get((Object)(name = (st = this.getShapeType()).getOoxmlName()));
        if (geom == null) {
            if (name == null && st != null) {
                name = st.toString();
            }
            this.logger.log(5, new Object[]{"No preset shape definition for shapeType: " + name});
            return null;
        }
        return geom;
    }

    public double getShadowAngle() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 517);
        int offX = prop == null ? 0 : prop.getPropertyValue();
        prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 518);
        int offY = prop == null ? 0 : prop.getPropertyValue();
        return Math.toDegrees(Math.atan2(offY, offX));
    }

    public double getShadowDistance() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 517);
        int offX = prop == null ? 0 : prop.getPropertyValue();
        prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 518);
        int offY = prop == null ? 0 : prop.getPropertyValue();
        return Units.toPoints((long)((long)Math.hypot(offX, offY)));
    }

    public Color getShadowColor() {
        Color clr = this.getColor((short)513, (short)516, -1);
        return clr == null ? Color.black : clr;
    }

    public Shadow<HSLFShape, HSLFTextParagraph> getShadow() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherProperty shadowType = opt.lookup(512);
        if (shadowType == null) {
            return null;
        }
        return new Shadow<HSLFShape, HSLFTextParagraph>(){

            public SimpleShape<HSLFShape, HSLFTextParagraph> getShadowParent() {
                return HSLFSimpleShape.this;
            }

            public double getDistance() {
                return HSLFSimpleShape.this.getShadowDistance();
            }

            public double getAngle() {
                return HSLFSimpleShape.this.getShadowAngle();
            }

            public double getBlur() {
                return 0.0;
            }

            public PaintStyle.SolidPaint getFillStyle() {
                return DrawPaint.createSolidPaint((Color)HSLFSimpleShape.this.getShadowColor());
            }
        };
    }

    public LineDecoration.DecorationShape getLineHeadDecoration() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 464);
        return prop == null ? null : LineDecoration.DecorationShape.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineHeadDecoration(LineDecoration.DecorationShape decoShape) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)464, decoShape == null ? -1 : decoShape.nativeId);
    }

    public LineDecoration.DecorationSize getLineHeadWidth() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 466);
        return prop == null ? null : LineDecoration.DecorationSize.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineHeadWidth(LineDecoration.DecorationSize decoSize) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)466, decoSize == null ? -1 : decoSize.nativeId);
    }

    public LineDecoration.DecorationSize getLineHeadLength() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 467);
        return prop == null ? null : LineDecoration.DecorationSize.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineHeadLength(LineDecoration.DecorationSize decoSize) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)467, decoSize == null ? -1 : decoSize.nativeId);
    }

    public LineDecoration.DecorationShape getLineTailDecoration() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 465);
        return prop == null ? null : LineDecoration.DecorationShape.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineTailDecoration(LineDecoration.DecorationShape decoShape) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)465, decoShape == null ? -1 : decoShape.nativeId);
    }

    public LineDecoration.DecorationSize getLineTailWidth() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 468);
        return prop == null ? null : LineDecoration.DecorationSize.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineTailWidth(LineDecoration.DecorationSize decoSize) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)468, decoSize == null ? -1 : decoSize.nativeId);
    }

    public LineDecoration.DecorationSize getLineTailLength() {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        EscherSimpleProperty prop = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(opt, 469);
        return prop == null ? null : LineDecoration.DecorationSize.fromNativeId((int)prop.getPropertyValue());
    }

    public void setLineTailLength(LineDecoration.DecorationSize decoSize) {
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)469, decoSize == null ? -1 : decoSize.nativeId);
    }

    public LineDecoration getLineDecoration() {
        return new LineDecoration(){

            public LineDecoration.DecorationShape getHeadShape() {
                return HSLFSimpleShape.this.getLineHeadDecoration();
            }

            public LineDecoration.DecorationSize getHeadWidth() {
                return HSLFSimpleShape.this.getLineHeadWidth();
            }

            public LineDecoration.DecorationSize getHeadLength() {
                return HSLFSimpleShape.this.getLineHeadLength();
            }

            public LineDecoration.DecorationShape getTailShape() {
                return HSLFSimpleShape.this.getLineTailDecoration();
            }

            public LineDecoration.DecorationSize getTailWidth() {
                return HSLFSimpleShape.this.getLineTailWidth();
            }

            public LineDecoration.DecorationSize getTailLength() {
                return HSLFSimpleShape.this.getLineTailLength();
            }
        };
    }

    protected void setPlaceholder(SimpleShape.Placeholder placeholder) {
        byte phId;
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        int flags = spRecord.getFlags();
        spRecord.setFlags(flags |= 0x220);
        EscherClientDataRecord cldata = (EscherClientDataRecord)this._escherContainer.getChildById((short)-4079);
        if (cldata == null) {
            cldata = new EscherClientDataRecord();
            this._escherContainer.addChildBefore((EscherRecord)cldata, -4083);
        }
        cldata.setOptions((short)15);
        AbstractEscherOptRecord opt = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(opt, (short)127, 262144);
        OEPlaceholderAtom oep = new OEPlaceholderAtom();
        oep.setPlacementId(-1);
        boolean isMaster = this.getSheet() instanceof HSLFSlideMaster;
        boolean isNotes = this.getSheet() instanceof HSLFNotes;
        switch (placeholder) {
            case TITLE: {
                phId = isMaster ? (byte)1 : 13;
                break;
            }
            case BODY: {
                phId = isMaster ? (byte)2 : (isNotes ? (byte)12 : 14);
                break;
            }
            case CENTERED_TITLE: {
                phId = isMaster ? (byte)3 : 15;
                break;
            }
            case SUBTITLE: {
                phId = isMaster ? (byte)4 : 16;
                break;
            }
            case DATETIME: {
                phId = 7;
                break;
            }
            case SLIDE_NUMBER: {
                phId = 8;
                break;
            }
            case FOOTER: {
                phId = 9;
                break;
            }
            case HEADER: {
                phId = 10;
                break;
            }
            case DGM: 
            case CHART: {
                phId = 20;
                break;
            }
            case TABLE: {
                phId = 21;
                break;
            }
            case PICTURE: 
            case CLIP_ART: {
                phId = 22;
                break;
            }
            case MEDIA: {
                phId = 24;
                break;
            }
            case SLIDE_IMAGE: {
                phId = isMaster ? (byte)5 : 11;
                break;
            }
            default: {
                phId = 19;
            }
        }
        oep.setPlaceholderId(phId);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            oep.writeOut(out);
        }
        catch (Exception e) {
            throw new HSLFException(e);
        }
        cldata.setRemainingData(out.toByteArray());
    }

    public void setStrokeStyle(Object ... styles) {
        if (styles.length == 0) {
            this.setLineColor(null);
            return;
        }
        for (Object st : styles) {
            if (st instanceof Number) {
                this.setLineWidth(((Number)st).doubleValue());
                continue;
            }
            if (st instanceof StrokeStyle.LineCap) {
                this.setLineCap((StrokeStyle.LineCap)st);
                continue;
            }
            if (st instanceof StrokeStyle.LineDash) {
                this.setLineDash((StrokeStyle.LineDash)st);
                continue;
            }
            if (st instanceof StrokeStyle.LineCompound) {
                this.setLineCompound((StrokeStyle.LineCompound)st);
                continue;
            }
            if (!(st instanceof Color)) continue;
            this.setLineColor((Color)st);
        }
    }
}

