/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherDgRecord;
import org.apache.poi.ddf.EscherDggRecord;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hslf.model.Comment;
import org.apache.poi.hslf.model.HeadersFooters;
import org.apache.poi.hslf.record.ColorSchemeAtom;
import org.apache.poi.hslf.record.Comment2000;
import org.apache.poi.hslf.record.EscherTextboxWrapper;
import org.apache.poi.hslf.record.HeadersFootersContainer;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.SSSlideInfoAtom;
import org.apache.poi.hslf.record.Slide;
import org.apache.poi.hslf.record.SlideAtom;
import org.apache.poi.hslf.record.SlideListWithText;
import org.apache.poi.hslf.record.StyleTextProp9Atom;
import org.apache.poi.hslf.usermodel.HSLFBackground;
import org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import org.apache.poi.hslf.usermodel.HSLFNotes;
import org.apache.poi.hslf.usermodel.HSLFPlaceholder;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSheet;
import org.apache.poi.hslf.usermodel.HSLFSlideMaster;
import org.apache.poi.hslf.usermodel.HSLFTextBox;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.hslf.usermodel.HSLFTextShape;
import org.apache.poi.hslf.usermodel.HSLFTitleMaster;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawSlide;
import org.apache.poi.sl.usermodel.Notes;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.sl.usermodel.SimpleShape;

public final class HSLFSlide
extends HSLFSheet
implements org.apache.poi.sl.usermodel.Slide<HSLFShape, HSLFTextParagraph> {
    private int _slideNo;
    private SlideListWithText.SlideAtomsSet _atomSet;
    private final List<List<HSLFTextParagraph>> _paragraphs = new ArrayList<List<HSLFTextParagraph>>();
    private HSLFNotes _notes;

    public HSLFSlide(Slide slide, HSLFNotes notes, SlideListWithText.SlideAtomsSet atomSet, int slideIdentifier, int slideNumber) {
        super(slide, slideIdentifier);
        this._notes = notes;
        this._atomSet = atomSet;
        this._slideNo = slideNumber;
        if (this._atomSet != null && this._atomSet.getSlideRecords().length > 0) {
            this._paragraphs.addAll(HSLFTextParagraph.findTextParagraphs(this._atomSet.getSlideRecords()));
            if (this._paragraphs.isEmpty()) {
                throw new RuntimeException("No text records found for slide");
            }
        }
        for (List<HSLFTextParagraph> l : HSLFTextParagraph.findTextParagraphs(this.getPPDrawing(), (HSLFSheet)this)) {
            if (this._paragraphs.contains(l)) continue;
            this._paragraphs.add(l);
        }
        for (List<HSLFTextParagraph> ltp : this._paragraphs) {
            for (HSLFTextParagraph tp : ltp) {
                tp.supplySheet(this);
            }
        }
    }

    public HSLFSlide(int sheetNumber, int sheetRefId, int slideNumber) {
        super(new Slide(), sheetNumber);
        this._slideNo = slideNumber;
        this.getSheetContainer().setSheetId(sheetRefId);
    }

    public HSLFNotes getNotes() {
        return this._notes;
    }

    public void setNotes(Notes<HSLFShape, HSLFTextParagraph> notes) {
        if (notes != null && !(notes instanceof HSLFNotes)) {
            throw new IllegalArgumentException("notes needs to be of type HSLFNotes");
        }
        this._notes = (HSLFNotes)notes;
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        if (this._notes == null) {
            sa.setNotesID(0);
        } else {
            sa.setNotesID(this._notes._getSheetNumber());
        }
    }

    public void setSlideNumber(int newSlideNumber) {
        this._slideNo = newSlideNumber;
    }

    @Override
    public void onCreate() {
        EscherDggRecord dgg = this.getSlideShow().getDocumentRecord().getPPDrawingGroup().getEscherDggRecord();
        EscherContainerRecord dgContainer = (EscherContainerRecord)this.getSheetContainer().getPPDrawing().getEscherRecords()[0];
        EscherDgRecord dg = (EscherDgRecord)HSLFShape.getEscherChild(dgContainer, -4088);
        int dgId = dgg.getMaxDrawingGroupId() + 1;
        dg.setOptions((short)(dgId << 4));
        dgg.setDrawingsSaved(dgg.getDrawingsSaved() + 1);
        dgg.setMaxDrawingGroupId(dgId);
        for (EscherContainerRecord c : dgContainer.getChildContainers()) {
            EscherSpRecord spr = null;
            switch (c.getRecordId()) {
                case -4093: {
                    EscherContainerRecord dc = (EscherContainerRecord)c.getChild(0);
                    spr = (EscherSpRecord)dc.getChildById((short)-4086);
                    break;
                }
                case -4092: {
                    spr = (EscherSpRecord)c.getChildById((short)-4086);
                    break;
                }
            }
            if (spr == null) continue;
            spr.setShapeId(this.allocateShapeId());
        }
        dg.setNumShapes(1);
    }

    public HSLFTextBox addTitle() {
        HSLFPlaceholder pl = new HSLFPlaceholder();
        pl.setShapeType(ShapeType.RECT);
        pl.setPlaceholder(SimpleShape.Placeholder.TITLE);
        pl.setRunType(0);
        pl.setText("Click to edit title");
        pl.setAnchor(new Rectangle(54, 48, 612, 90));
        this.addShape(pl);
        return pl;
    }

    public String getTitle() {
        for (List<HSLFTextParagraph> tp : this.getTextParagraphs()) {
            if (tp.isEmpty()) continue;
            int type = tp.get(0).getRunType();
            switch (type) {
                case 0: 
                case 6: {
                    String str = HSLFTextParagraph.getRawText(tp);
                    return HSLFTextParagraph.toExternalString(str, type);
                }
            }
        }
        return null;
    }

    @Override
    public List<List<HSLFTextParagraph>> getTextParagraphs() {
        return this._paragraphs;
    }

    public int getSlideNumber() {
        return this._slideNo;
    }

    public Slide getSlideRecord() {
        return (Slide)this.getSheetContainer();
    }

    protected SlideListWithText.SlideAtomsSet getSlideAtomsSet() {
        return this._atomSet;
    }

    @Override
    public HSLFMasterSheet getMasterSheet() {
        int masterId = this.getSlideRecord().getSlideAtom().getMasterID();
        for (HSLFSlideMaster sm : this.getSlideShow().getSlideMasters()) {
            if (masterId != sm._getSheetNumber()) continue;
            return sm;
        }
        for (HSLFTitleMaster tm : this.getSlideShow().getTitleMasters()) {
            if (masterId != tm._getSheetNumber()) continue;
            return tm;
        }
        return null;
    }

    public void setMasterSheet(HSLFMasterSheet master) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        int sheetNo = master._getSheetNumber();
        sa.setMasterID(sheetNo);
    }

    public void setFollowMasterBackground(boolean flag) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        sa.setFollowMasterBackground(flag);
    }

    public boolean getFollowMasterBackground() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterBackground();
    }

    public void setFollowMasterObjects(boolean flag) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        sa.setFollowMasterObjects(flag);
    }

    public boolean getFollowMasterScheme() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterScheme();
    }

    public void setFollowMasterScheme(boolean flag) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        sa.setFollowMasterScheme(flag);
    }

    public boolean getFollowMasterObjects() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterObjects();
    }

    @Override
    public HSLFBackground getBackground() {
        if (this.getFollowMasterBackground()) {
            return this.getMasterSheet().getBackground();
        }
        return super.getBackground();
    }

    @Override
    public ColorSchemeAtom getColorScheme() {
        if (this.getFollowMasterScheme()) {
            return this.getMasterSheet().getColorScheme();
        }
        return super.getColorScheme();
    }

    public Comment[] getComments() {
        RecordContainer binaryTags;
        RecordContainer progBinaryTag;
        RecordContainer progTags = (RecordContainer)this.getSheetContainer().findFirstOfType(RecordTypes.ProgTags.typeID);
        if (progTags != null && (progBinaryTag = (RecordContainer)progTags.findFirstOfType(RecordTypes.ProgBinaryTag.typeID)) != null && (binaryTags = (RecordContainer)progBinaryTag.findFirstOfType(RecordTypes.BinaryTagData.typeID)) != null) {
            int count = 0;
            for (int i = 0; i < binaryTags.getChildRecords().length; ++i) {
                if (!(binaryTags.getChildRecords()[i] instanceof Comment2000)) continue;
                ++count;
            }
            Comment[] comments = new Comment[count];
            count = 0;
            for (int i = 0; i < binaryTags.getChildRecords().length; ++i) {
                if (!(binaryTags.getChildRecords()[i] instanceof Comment2000)) continue;
                comments[i] = new Comment((Comment2000)binaryTags.getChildRecords()[i]);
                ++count;
            }
            return comments;
        }
        return new Comment[0];
    }

    public HeadersFooters getHeadersFooters() {
        HeadersFootersContainer hdd = null;
        Record[] ch = this.getSheetContainer().getChildRecords();
        boolean ppt2007 = false;
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] instanceof HeadersFootersContainer) {
                hdd = (HeadersFootersContainer)ch[i];
                continue;
            }
            if (ch[i].getRecordType() != (long)RecordTypes.RoundTripContentMasterId.typeID) continue;
            ppt2007 = true;
        }
        boolean newRecord = false;
        if (hdd == null && !ppt2007) {
            return this.getSlideShow().getSlideHeadersFooters();
        }
        if (hdd == null) {
            hdd = new HeadersFootersContainer(63);
            newRecord = true;
        }
        return new HeadersFooters(hdd, this, newRecord, ppt2007);
    }

    @Override
    protected void onAddTextShape(HSLFTextShape shape) {
        List<HSLFTextParagraph> newParas = shape.getTextParagraphs();
        this._paragraphs.add(newParas);
    }

    public StyleTextProp9Atom[] getNumberedListInfo() {
        return this.getPPDrawing().getNumberedListInfo();
    }

    public EscherTextboxWrapper[] getTextboxWrappers() {
        return this.getPPDrawing().getTextboxWrappers();
    }

    public void setHidden(boolean hidden) {
        Slide cont = this.getSlideRecord();
        SSSlideInfoAtom slideInfo = (SSSlideInfoAtom)cont.findFirstOfType(RecordTypes.SSSlideInfoAtom.typeID);
        if (slideInfo == null) {
            slideInfo = new SSSlideInfoAtom();
            cont.addChildAfter(slideInfo, cont.findFirstOfType(RecordTypes.SlideAtom.typeID));
        }
        slideInfo.setEffectTransitionFlagByBit(4, hidden);
    }

    public boolean getHidden() {
        SSSlideInfoAtom slideInfo = (SSSlideInfoAtom)this.getSlideRecord().findFirstOfType(RecordTypes.SSSlideInfoAtom.typeID);
        return slideInfo == null ? false : slideInfo.getEffectTransitionFlagByBit(4);
    }

    @Override
    public void draw(Graphics2D graphics) {
        DrawFactory drawFact = DrawFactory.getInstance((Graphics2D)graphics);
        DrawSlide draw = drawFact.getDrawable((org.apache.poi.sl.usermodel.Slide)this);
        draw.draw(graphics);
    }

    public boolean getFollowMasterColourScheme() {
        return false;
    }

    public void setFollowMasterColourScheme(boolean follow) {
    }

    @Override
    public boolean getFollowMasterGraphics() {
        return this.getFollowMasterObjects();
    }
}

