/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.poi.POIDocument;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.record.CurrentUserAtom;
import org.apache.poi.hslf.record.DocumentEncryptionAtom;
import org.apache.poi.hslf.record.ExOleObjStg;
import org.apache.poi.hslf.record.PersistPtrHolder;
import org.apache.poi.hslf.record.PersistRecord;
import org.apache.poi.hslf.record.PositionDependentRecord;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.UserEditAtom;
import org.apache.poi.hslf.usermodel.HSLFObjectData;
import org.apache.poi.hslf.usermodel.HSLFPictureData;
import org.apache.poi.hslf.usermodel.HSLFSlideShowEncrypted;
import org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptor;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.EntryUtils;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class HSLFSlideShowImpl
extends POIDocument
implements Closeable {
    public static final int UNSET_OFFSET = -1;
    private POILogger logger = POILogFactory.getLogger(this.getClass());
    private CurrentUserAtom currentUser;
    private byte[] _docstream;
    private Record[] _records;
    private List<HSLFPictureData> _pictures;
    private HSLFObjectData[] _objects;

    protected DirectoryNode getPOIFSDirectory() {
        return this.directory;
    }

    public HSLFSlideShowImpl(String fileName) throws IOException {
        this(new POIFSFileSystem(new File(fileName)));
    }

    public HSLFSlideShowImpl(InputStream inputStream) throws IOException {
        this(new POIFSFileSystem(inputStream));
    }

    public HSLFSlideShowImpl(POIFSFileSystem filesystem) throws IOException {
        this(filesystem.getRoot());
    }

    public HSLFSlideShowImpl(NPOIFSFileSystem filesystem) throws IOException {
        this(filesystem.getRoot());
    }

    public HSLFSlideShowImpl(DirectoryNode dir) throws IOException {
        super(HSLFSlideShowImpl.handleDualStorage(dir));
        this.readCurrentUserStream();
        this.readPowerPointStream();
        this.buildRecords();
        this.readOtherStreams();
    }

    private static DirectoryNode handleDualStorage(DirectoryNode dir) throws IOException {
        String dualName = "PP97_DUALSTORAGE";
        if (!dir.hasEntry(dualName)) {
            return dir;
        }
        dir = (DirectoryNode)dir.getEntry(dualName);
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HSLFSlideShowImpl create() {
        HSLFSlideShowImpl hSLFSlideShowImpl;
        InputStream is = HSLFSlideShowImpl.class.getResourceAsStream("/org/apache/poi/hslf/data/empty.ppt");
        if (is == null) {
            throw new HSLFException("Missing resource 'empty.ppt'");
        }
        try {
            hSLFSlideShowImpl = new HSLFSlideShowImpl(is);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new HSLFException(e);
            }
        }
        is.close();
        return hSLFSlideShowImpl;
    }

    private void readPowerPointStream() throws IOException {
        DocumentEntry docProps = (DocumentEntry)this.directory.getEntry("PowerPoint Document");
        int len = docProps.getSize();
        this._docstream = new byte[len];
        DocumentInputStream is = this.directory.createDocumentInputStream("PowerPoint Document");
        int readLen = is.read(this._docstream);
        is.close();
        if (len != readLen) {
            throw new IOException("Document input stream ended prematurely - expected " + len + " bytes - received " + readLen + " bytes");
        }
    }

    private void buildRecords() {
        this._records = this.read(this._docstream, (int)this.currentUser.getCurrentEditOffset());
    }

    private Record[] read(byte[] docstream, int usrOffset) {
        TreeMap<Integer, Record> records = new TreeMap<Integer, Record>();
        HashMap<Integer, Integer> persistIds = new HashMap<Integer, Integer>();
        this.initRecordOffsets(docstream, usrOffset, records, persistIds);
        HSLFSlideShowEncrypted decryptData = new HSLFSlideShowEncrypted(docstream, records);
        for (Map.Entry entry : records.entrySet()) {
            Integer offset = (Integer)entry.getKey();
            Record record = (Record)entry.getValue();
            Integer persistId = (Integer)persistIds.get(offset);
            if (record == null) {
                decryptData.decryptRecord(docstream, persistId, offset);
                record = Record.buildRecordAtOffset(docstream, offset);
                entry.setValue(record);
            }
            if (!(record instanceof PersistRecord)) continue;
            ((PersistRecord)((Object)record)).setPersistId(persistId);
        }
        return records.values().toArray(new Record[records.size()]);
    }

    private void initRecordOffsets(byte[] docstream, int usrOffset, NavigableMap<Integer, Record> recordMap, Map<Integer, Integer> offset2id) {
        while (usrOffset != 0) {
            UserEditAtom usr = (UserEditAtom)Record.buildRecordAtOffset(docstream, usrOffset);
            recordMap.put(usrOffset, usr);
            int psrOffset = usr.getPersistPointersOffset();
            PersistPtrHolder ptr = (PersistPtrHolder)Record.buildRecordAtOffset(docstream, psrOffset);
            recordMap.put(psrOffset, ptr);
            for (Map.Entry<Integer, Integer> entry : ptr.getSlideLocationsLookup().entrySet()) {
                Integer offset = entry.getValue();
                Integer id = entry.getKey();
                recordMap.put(offset, null);
                offset2id.put(offset, id);
            }
            usrOffset = usr.getLastUserEditAtomOffset();
            if (usrOffset <= 0 || !recordMap.containsKey(usrOffset)) continue;
            usrOffset = (Integer)recordMap.firstKey() - 36;
            int ver_inst = LittleEndian.getUShort((byte[])docstream, (int)usrOffset);
            int type = LittleEndian.getUShort((byte[])docstream, (int)(usrOffset + 2));
            int len = LittleEndian.getInt((byte[])docstream, (int)(usrOffset + 4));
            if (ver_inst == 0 && type == 4085 && (len == 28 || len == 32)) {
                this.logger.log(5, new Object[]{"Repairing invalid user edit atom"});
                usr.setLastUserEditAtomOffset(usrOffset);
                continue;
            }
            throw new CorruptPowerPointFileException("Powerpoint document contains invalid user edit atom");
        }
    }

    public DocumentEncryptionAtom getDocumentEncryptionAtom() {
        for (Record r : this._records) {
            if (!(r instanceof DocumentEncryptionAtom)) continue;
            return (DocumentEncryptionAtom)r;
        }
        return null;
    }

    private void readCurrentUserStream() {
        try {
            this.currentUser = new CurrentUserAtom(this.directory);
        }
        catch (IOException ie) {
            this.logger.log(7, new Object[]{"Error finding Current User Atom:\n" + ie});
            this.currentUser = new CurrentUserAtom();
        }
    }

    private void readOtherStreams() {
    }

    private void readPictures() throws IOException {
        int imgsize;
        this._pictures = new ArrayList<HSLFPictureData>();
        if (!this.directory.hasEntry("Pictures")) {
            return;
        }
        HSLFSlideShowEncrypted decryptData = new HSLFSlideShowEncrypted(this.getDocumentEncryptionAtom());
        DocumentEntry entry = (DocumentEntry)this.directory.getEntry("Pictures");
        int len = entry.getSize();
        byte[] pictstream = new byte[len];
        DocumentInputStream is = this.directory.createDocumentInputStream((Entry)entry);
        int readLen = is.read(pictstream);
        is.close();
        if (len != readLen) {
            throw new IOException("Picture stream ended prematurely - expected " + len + " bytes - received " + readLen + " bytes");
        }
        for (int pos = 0; pos <= pictstream.length - 8; pos += imgsize) {
            int offset = pos;
            decryptData.decryptPicture(pictstream, offset);
            int signature = LittleEndian.getUShort((byte[])pictstream, (int)pos);
            int type = LittleEndian.getUShort((byte[])pictstream, (int)(pos += 2));
            imgsize = LittleEndian.getInt((byte[])pictstream, (int)(pos += 2));
            pos += 4;
            if (type != 61447 && (type < 61464 || type > 61719)) break;
            if (imgsize < 0) {
                throw new CorruptPowerPointFileException("The file contains a picture, at position " + this._pictures.size() + ", which has a negatively sized data length, so we can't trust any of the picture data");
            }
            PictureData.PictureType pt = PictureData.PictureType.forNativeID((int)(type - 61464));
            if (pt == null) {
                this.logger.log(7, new Object[]{"Problem reading picture: Invalid image type 0, on picture with length " + imgsize + ".\nYou document will probably become corrupted if you save it!"});
                this.logger.log(7, new Object[]{"" + pos});
                continue;
            }
            try {
                HSLFPictureData pict = HSLFPictureData.create(pt);
                pict.setSignature(signature);
                byte[] imgdata = new byte[imgsize];
                System.arraycopy(pictstream, pos, imgdata, 0, imgdata.length);
                pict.setRawData(imgdata);
                pict.setOffset(offset);
                pict.setIndex(this._pictures.size());
                this._pictures.add(pict);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.logger.log(7, new Object[]{"Problem reading picture: " + e + "\nYou document will probably become corrupted if you save it!"});
            }
        }
    }

    public void normalizeRecords() {
        try {
            this.updateAndWriteDependantRecords(null, null);
        }
        catch (IOException e) {
            throw new CorruptPowerPointFileException(e);
        }
        this._records = HSLFSlideShowEncrypted.normalizeRecords(this._records);
    }

    public void updateAndWriteDependantRecords(OutputStream os, Map<RecordTypes, PositionDependentRecord> interestingRecords) throws IOException {
        HashMap<Integer, Integer> oldToNewPositions = new HashMap<Integer, Integer>();
        UserEditAtom usr = null;
        PersistPtrHolder ptr = null;
        CountingOS cos = new CountingOS();
        for (Record record : this._records) {
            assert (record instanceof PositionDependentRecord);
            PositionDependentRecord pdr = (PositionDependentRecord)((Object)record);
            int oldPos = pdr.getLastOnDiskOffset();
            int newPos = cos.size();
            pdr.setLastOnDiskOffset(newPos);
            if (oldPos != -1) {
                oldToNewPositions.put(oldPos, newPos);
            }
            RecordTypes saveme = null;
            int recordType = (int)record.getRecordType();
            if (recordType == RecordTypes.PersistPtrIncrementalBlock.typeID) {
                saveme = RecordTypes.PersistPtrIncrementalBlock;
                ptr = (PersistPtrHolder)pdr;
            } else if (recordType == RecordTypes.UserEditAtom.typeID) {
                saveme = RecordTypes.UserEditAtom;
                usr = (UserEditAtom)pdr;
            }
            if (interestingRecords != null && saveme != null) {
                interestingRecords.put(saveme, pdr);
            }
            record.writeOut(cos);
        }
        cos.close();
        if (usr == null || ptr == null) {
            throw new HSLFException("UserEditAtom or PersistPtr can't be determined.");
        }
        HashMap persistIds = new HashMap();
        for (Map.Entry<Integer, Integer> entry : ptr.getSlideLocationsLookup().entrySet()) {
            persistIds.put(oldToNewPositions.get(entry.getValue()), entry.getKey());
        }
        HSLFSlideShowEncrypted encData = new HSLFSlideShowEncrypted(this.getDocumentEncryptionAtom());
        for (Record record : this._records) {
            assert (record instanceof PositionDependentRecord);
            PositionDependentRecord pdr = (PositionDependentRecord)((Object)record);
            Integer persistId = (Integer)persistIds.get(pdr.getLastOnDiskOffset());
            if (persistId == null) {
                persistId = 0;
            }
            pdr.updateOtherRecordReferences(oldToNewPositions);
            if (os == null) continue;
            record.writeOut(encData.encryptRecord(os, persistId, record));
        }
        int oldLastUserEditAtomPos = (int)this.currentUser.getCurrentEditOffset();
        Integer newLastUserEditAtomPos = (Integer)oldToNewPositions.get(oldLastUserEditAtomPos);
        if (newLastUserEditAtomPos == null || usr.getLastOnDiskOffset() != newLastUserEditAtomPos.intValue()) {
            throw new HSLFException("Couldn't find the new location of the last UserEditAtom that used to be at " + oldLastUserEditAtomPos);
        }
        this.currentUser.setCurrentEditOffset(usr.getLastOnDiskOffset());
    }

    public void write(OutputStream out) throws IOException {
        this.write(out, false);
    }

    public void write(OutputStream out, boolean preserveNodes) throws IOException {
        if (this._pictures == null) {
            this.readPictures();
        }
        this.getDocumentSummaryInformation();
        HSLFSlideShowEncrypted encryptedSS = new HSLFSlideShowEncrypted(this.getDocumentEncryptionAtom());
        this._records = encryptedSS.updateEncryptionRecord(this._records);
        POIFSFileSystem outFS = new POIFSFileSystem();
        ArrayList<String> writtenEntries = new ArrayList<String>(1);
        this.writeProperties(outFS, writtenEntries);
        BufAccessBAOS baos = new BufAccessBAOS();
        this.updateAndWriteDependantRecords(baos, null);
        this._docstream = new byte[baos.size()];
        System.arraycopy(baos.getBuf(), 0, this._docstream, 0, baos.size());
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(this._docstream);
        outFS.createDocument((InputStream)bais, "PowerPoint Document");
        writtenEntries.add("PowerPoint Document");
        this.currentUser.setEncrypted(encryptedSS.getDocumentEncryptionAtom() != null);
        this.currentUser.writeToFS((NPOIFSFileSystem)outFS);
        writtenEntries.add("Current User");
        if (this._pictures.size() > 0) {
            BufAccessBAOS pict = new BufAccessBAOS();
            for (HSLFPictureData p : this._pictures) {
                int offset = pict.size();
                p.write(pict);
                encryptedSS.encryptPicture(pict.getBuf(), offset);
            }
            outFS.createDocument((InputStream)new ByteArrayInputStream(pict.getBuf(), 0, pict.size()), "Pictures");
            writtenEntries.add("Pictures");
            pict.close();
        }
        if (preserveNodes) {
            EntryUtils.copyNodes((NPOIFSFileSystem)this.directory.getFileSystem(), (NPOIFSFileSystem)outFS, writtenEntries);
        }
        outFS.writeFilesystem(out);
        outFS.close();
    }

    protected PropertySet getPropertySet(String setName) {
        DocumentEncryptionAtom dea = this.getDocumentEncryptionAtom();
        return dea == null ? super.getPropertySet(setName) : super.getPropertySet(setName, dea.getEncryptionInfo());
    }

    protected void writeProperties(POIFSFileSystem outFS, List<String> writtenEntries) throws IOException {
        super.writeProperties((NPOIFSFileSystem)outFS, writtenEntries);
        DocumentEncryptionAtom dea = this.getDocumentEncryptionAtom();
        if (dea != null) {
            CryptoAPIEncryptor enc = (CryptoAPIEncryptor)dea.getEncryptionInfo().getEncryptor();
            try {
                enc.getDataStream(outFS.getRoot());
            }
            catch (IOException e) {
                throw e;
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
        }
    }

    public synchronized int appendRootLevelRecord(Record newRecord) {
        int addedAt = -1;
        Record[] r = new Record[this._records.length + 1];
        boolean added = false;
        for (int i = this._records.length - 1; i >= 0; --i) {
            if (added) {
                r[i] = this._records[i];
                continue;
            }
            r[i + 1] = this._records[i];
            if (!(this._records[i] instanceof PersistPtrHolder)) continue;
            r[i] = newRecord;
            added = true;
            addedAt = i;
        }
        this._records = r;
        return addedAt;
    }

    public int addPicture(HSLFPictureData img) {
        if (this._pictures == null) {
            try {
                this.readPictures();
            }
            catch (IOException e) {
                throw new CorruptPowerPointFileException(e.getMessage());
            }
        }
        int offset = 0;
        if (this._pictures.size() > 0) {
            HSLFPictureData prev = this._pictures.get(this._pictures.size() - 1);
            offset = prev.getOffset() + prev.getRawData().length + 8;
        }
        img.setOffset(offset);
        img.setIndex(this._pictures.size() + 1);
        this._pictures.add(img);
        return offset;
    }

    public Record[] getRecords() {
        return this._records;
    }

    public byte[] getUnderlyingBytes() {
        return this._docstream;
    }

    public CurrentUserAtom getCurrentUserAtom() {
        return this.currentUser;
    }

    public List<HSLFPictureData> getPictureData() {
        if (this._pictures == null) {
            try {
                this.readPictures();
            }
            catch (IOException e) {
                throw new CorruptPowerPointFileException(e.getMessage());
            }
        }
        return Collections.unmodifiableList(this._pictures);
    }

    public HSLFObjectData[] getEmbeddedObjects() {
        if (this._objects == null) {
            ArrayList<HSLFObjectData> objects = new ArrayList<HSLFObjectData>();
            for (Record r : this._records) {
                if (!(r instanceof ExOleObjStg)) continue;
                objects.add(new HSLFObjectData((ExOleObjStg)r));
            }
            this._objects = objects.toArray(new HSLFObjectData[objects.size()]);
        }
        return this._objects;
    }

    @Override
    public void close() throws IOException {
        NPOIFSFileSystem fs = this.directory.getFileSystem();
        if (fs != null) {
            fs.close();
        }
    }

    private static class CountingOS
    extends OutputStream {
        int count = 0;

        private CountingOS() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.count;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.count += b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.count += len;
        }

        public int size() {
            return this.count;
        }
    }

    private static class BufAccessBAOS
    extends ByteArrayOutputStream {
        private BufAccessBAOS() {
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }
}

