/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdgf.pointers;

import org.apache.poi.hdgf.pointers.Pointer;
import org.apache.poi.util.LittleEndian;

public final class PointerV5
extends Pointer {
    @Override
    public boolean destinationHasStrings() {
        return 64 <= this.format && this.format < 80;
    }

    @Override
    public boolean destinationHasPointers() {
        if (this.type == 20) {
            return true;
        }
        if (this.type == 22) {
            return false;
        }
        if (this.format == 29 || this.format == 30) {
            return true;
        }
        return 80 <= this.format && this.format < 96;
    }

    @Override
    public boolean destinationHasChunks() {
        if (this.type == 21) {
            return true;
        }
        if (this.type == 24) {
            return true;
        }
        return 208 <= this.format && this.format < 223;
    }

    @Override
    public boolean destinationCompressed() {
        return (this.format & 2) > 0;
    }

    @Override
    public int getSizeInBytes() {
        return 16;
    }

    @Override
    public int getNumPointersOffset(byte[] data) {
        switch (this.type) {
            case 29: 
            case 78: {
                return 30;
            }
            case 30: {
                return 54;
            }
            case 20: {
                return 130;
            }
        }
        return 10;
    }

    @Override
    public int getNumPointers(int offset, byte[] data) {
        return LittleEndian.getShort((byte[])data, (int)offset);
    }

    @Override
    public int getPostNumPointersSkip() {
        return 2;
    }
}

