/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;
import org.apache.poi.hslf.blip.Metafile;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.Units;

public final class PICT
extends Metafile {
    private static final POILogger LOG = POILogFactory.getLogger(PICT.class);

    public byte[] getData() {
        byte[] rawdata = this.getRawData();
        try {
            byte[] macheader = new byte[512];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(macheader);
            int pos = 16 * this.uidInstanceCount;
            byte[] pict = this.read(rawdata, pos);
            out.write(pict);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] read(byte[] data, int pos) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        Metafile.Header header = new Metafile.Header();
        header.read(data, pos);
        bis.skip(pos + header.getSize());
        byte[] chunk = new byte[4096];
        ByteArrayOutputStream out = new ByteArrayOutputStream(header.getWmfSize());
        InflaterInputStream inflater = new InflaterInputStream(bis);
        try {
            int count;
            while ((count = inflater.read(chunk)) >= 0) {
                out.write(chunk, 0, count);
                PICT.bytefill(chunk, (byte)0);
            }
        }
        catch (Exception e) {
            int lastLen;
            for (lastLen = chunk.length - 1; lastLen >= 0 && chunk[lastLen] == 0; --lastLen) {
            }
            if (++lastLen > 0) {
                if (header.getWmfSize() > out.size()) {
                    lastLen = Math.min(lastLen, header.getWmfSize() - out.size());
                }
                out.write(chunk, 0, lastLen);
            }
            LOG.log(7, new Object[]{"PICT zip-stream is invalid, read as much as possible. Uncompressed length of header: " + header.getWmfSize() + " / Read bytes: " + out.size(), e});
        }
        finally {
            inflater.close();
        }
        return out.toByteArray();
    }

    public void setData(byte[] data) throws IOException {
        int nOffset = 512;
        NativeHeader nHeader = new NativeHeader(data, 512);
        Metafile.Header header = new Metafile.Header();
        header.wmfsize = data.length - 512;
        byte[] compressed = PICT.compress(data, 512, header.wmfsize);
        header.zipsize = compressed.length;
        header.bounds = nHeader.bounds;
        Dimension nDim = nHeader.getSize();
        header.size = new Dimension(Units.toEMU((double)nDim.getWidth()), Units.toEMU((double)nDim.getHeight()));
        byte[] checksum = PICT.getChecksum(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(checksum);
        if (this.uidInstanceCount == 2) {
            out.write(checksum);
        }
        header.write(out);
        out.write(compressed);
        this.setRawData(out.toByteArray());
    }

    public PictureData.PictureType getType() {
        return PictureData.PictureType.PICT;
    }

    @Override
    public int getSignature() {
        return this.uidInstanceCount == 1 ? 21536 : 21552;
    }

    @Override
    public void setSignature(int signature) {
        switch (signature) {
            case 21536: {
                this.uidInstanceCount = 1;
                break;
            }
            case 21552: {
                this.uidInstanceCount = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException(signature + " is not a valid instance/signature value for PICT");
            }
        }
    }

    private static void bytefill(byte[] array, byte value) {
        int len = array.length;
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static class NativeHeader {
        public static final int PICT_HEADER_OFFSET = 512;
        public static final double DEFAULT_RESOLUTION = 72.0;
        private static final byte[] V2_HEADER = new byte[]{0, 17, 2, -1, 12, 0, -1, -2, 0, 0};
        public final Rectangle bounds;
        public final double hRes;
        public final double vRes;

        public NativeHeader(byte[] data, int offset) {
            int y1 = NativeHeader.readUnsignedShort(data, offset += 2);
            int x1 = NativeHeader.readUnsignedShort(data, offset += 2);
            int y2 = NativeHeader.readUnsignedShort(data, offset += 2);
            int x2 = NativeHeader.readUnsignedShort(data, offset += 2);
            offset += 2;
            boolean isV2 = true;
            for (byte b : V2_HEADER) {
                if (b == data[offset++]) continue;
                isV2 = false;
                break;
            }
            if (isV2) {
                this.hRes = NativeHeader.readFixedPoint(data, offset);
                this.vRes = NativeHeader.readFixedPoint(data, offset += 4);
                offset += 4;
            } else {
                this.hRes = 72.0;
                this.vRes = 72.0;
            }
            this.bounds = new Rectangle(x1, y1, x2 - x1, y2 - y1);
        }

        public Dimension getSize() {
            int height = (int)Math.round((double)this.bounds.height * 72.0 / this.vRes);
            int width = (int)Math.round((double)this.bounds.width * 72.0 / this.hRes);
            return new Dimension(width, height);
        }

        private static int readUnsignedShort(byte[] data, int offset) {
            int b0 = data[offset] & 0xFF;
            int b1 = data[offset + 1] & 0xFF;
            return b0 << 8 | b1;
        }

        private static double readFixedPoint(byte[] data, int offset) {
            int b0 = data[offset] & 0xFF;
            int b1 = data[offset + 1] & 0xFF;
            int b2 = data[offset + 2] & 0xFF;
            int b3 = data[offset + 3] & 0xFF;
            int i = b0 << 24 | b1 << 16 | b2 << 8 | b3;
            return (double)i / 65536.0;
        }
    }
}

