/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.hsmf.parsers.POIFSChunkParser;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MAPIMessage {
    private POIFSChunkParser chunkParser;
    private POIFSFileSystem fs;
    private Chunks chunks;

    public MAPIMessage() {
    }

    public MAPIMessage(String filename) throws IOException {
        this(new FileInputStream(new File(filename)));
    }

    public MAPIMessage(InputStream in) throws IOException {
        this.fs = new POIFSFileSystem(in);
        this.chunkParser = new POIFSChunkParser(this.fs);
        this.chunks = this.chunkParser.identifyChunks();
    }

    public String getStringFromChunk(StringChunk chunk) throws ChunkNotFoundException {
        Chunk out = this.chunkParser.getDocumentNode(chunk);
        StringChunk strchunk = (StringChunk)out;
        return strchunk.toString();
    }

    public String getTextBody() throws IOException, ChunkNotFoundException {
        return this.getStringFromChunk(this.chunks.textBodyChunk);
    }

    public String getSubject() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.chunks.subjectChunk);
    }

    public String getDisplayTo() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.chunks.displayToChunk);
    }

    public String getDisplayFrom() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.chunks.displayFromChunk);
    }

    public String getDisplayCC() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.chunks.displayCCChunk);
    }

    public String getDisplayBCC() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.chunks.displayBCCChunk);
    }

    public String getConversationTopic() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.chunks.conversationTopic);
    }

    public String getMessageClass() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.chunks.messageClass);
    }
}

