/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.record;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.RecordFormatException;

public class HwmfBitmapDib {
    private static final POILogger logger = POILogFactory.getLogger(HwmfBitmapDib.class);
    private static final int BMP_HEADER_SIZE = 14;
    private static final int MAX_RECORD_LENGTH = 50000000;
    private int headerSize;
    private int headerWidth;
    private int headerHeight;
    private int headerPlanes;
    private BitCount headerBitCount;
    private Compression headerCompression;
    private long headerImageSize = -1L;
    private int headerXPelsPerMeter = -1;
    private int headerYPelsPerMeter = -1;
    private long headerColorUsed = -1L;
    private long headerColorImportant = -1L;
    private Color[] colorTable;
    private int colorMaskR;
    private int colorMaskG;
    private int colorMaskB;
    private int introSize;
    private byte[] imageData;

    public int init(LittleEndianInputStream leis, int recordSize) throws IOException {
        leis.mark(10000);
        this.introSize = this.readHeader(leis);
        assert (this.introSize == this.headerSize);
        this.introSize += this.readColors(leis);
        assert (this.introSize < 10000);
        leis.reset();
        int bodySize = (this.headerWidth * this.headerPlanes * this.headerBitCount.flag + 31 & 0xFFFFFFE0) / 8 * Math.abs(this.headerHeight);
        assert (this.headerSize != 12 || (long)bodySize == this.headerImageSize);
        if (this.headerSize == 12 || this.headerCompression == Compression.BI_RGB || this.headerCompression == Compression.BI_BITFIELDS || this.headerCompression == Compression.BI_CMYK) {
            int fileSize = Math.min(this.introSize + bodySize, recordSize);
            this.imageData = IOUtils.safelyAllocate((long)fileSize, (int)50000000);
            leis.readFully(this.imageData, 0, this.introSize);
            leis.skipFully(recordSize - fileSize);
            int readBytes = leis.read(this.imageData, this.introSize, fileSize - this.introSize);
            return this.introSize + (recordSize - fileSize) + readBytes;
        }
        this.imageData = IOUtils.safelyAllocate((long)recordSize, (int)50000000);
        leis.readFully(this.imageData);
        return recordSize;
    }

    protected int readHeader(LittleEndianInputStream leis) throws IOException {
        int size = 0;
        this.headerSize = leis.readInt();
        size += 4;
        if (this.headerSize == 12) {
            this.headerWidth = leis.readUShort();
            this.headerHeight = leis.readUShort();
            this.headerPlanes = leis.readUShort();
            this.headerBitCount = BitCount.valueOf(leis.readUShort());
            size += 8;
        } else {
            this.headerSize = 40;
            this.headerWidth = leis.readInt();
            this.headerHeight = leis.readInt();
            this.headerPlanes = leis.readUShort();
            this.headerBitCount = BitCount.valueOf(leis.readUShort());
            this.headerCompression = Compression.valueOf((int)leis.readUInt());
            this.headerImageSize = leis.readUInt();
            this.headerXPelsPerMeter = leis.readInt();
            this.headerYPelsPerMeter = leis.readInt();
            this.headerColorUsed = leis.readUInt();
            this.headerColorImportant = leis.readUInt();
            size += 36;
        }
        return size;
    }

    protected int readColors(LittleEndianInputStream leis) throws IOException {
        switch (this.headerBitCount) {
            default: {
                return 0;
            }
            case BI_BITCOUNT_1: {
                return this.readRGBQuad(leis, (int)(this.headerColorUsed == 0L ? 2L : Math.min(this.headerColorUsed, 2L)));
            }
            case BI_BITCOUNT_2: {
                return this.readRGBQuad(leis, (int)(this.headerColorUsed == 0L ? 16L : Math.min(this.headerColorUsed, 16L)));
            }
            case BI_BITCOUNT_3: {
                return this.readRGBQuad(leis, (int)(this.headerColorUsed == 0L ? 256L : Math.min(this.headerColorUsed, 256L)));
            }
            case BI_BITCOUNT_4: {
                switch (this.headerCompression) {
                    case BI_RGB: {
                        this.colorMaskB = 31;
                        this.colorMaskG = 992;
                        this.colorMaskR = 31744;
                        return 0;
                    }
                    case BI_BITFIELDS: {
                        this.colorMaskB = leis.readInt();
                        this.colorMaskG = leis.readInt();
                        this.colorMaskR = leis.readInt();
                        return 12;
                    }
                }
                throw new IOException("Invalid compression option (" + (Object)((Object)this.headerCompression) + ") for bitcount (" + (Object)((Object)this.headerBitCount) + ").");
            }
            case BI_BITCOUNT_5: 
            case BI_BITCOUNT_6: 
        }
        switch (this.headerCompression) {
            case BI_RGB: {
                this.colorMaskR = 255;
                this.colorMaskG = 255;
                this.colorMaskB = 255;
                return 0;
            }
            case BI_BITFIELDS: {
                this.colorMaskB = leis.readInt();
                this.colorMaskG = leis.readInt();
                this.colorMaskR = leis.readInt();
                return 12;
            }
        }
        throw new IOException("Invalid compression option (" + (Object)((Object)this.headerCompression) + ") for bitcount (" + (Object)((Object)this.headerBitCount) + ").");
    }

    protected int readRGBQuad(LittleEndianInputStream leis, int count) throws IOException {
        int size = 0;
        this.colorTable = new Color[count];
        for (int i = 0; i < count; ++i) {
            int blue = leis.readUByte();
            int green = leis.readUByte();
            int red = leis.readUByte();
            int reserved = leis.readUByte();
            this.colorTable[i] = new Color(red, green, blue);
            size += 4;
        }
        return size;
    }

    public boolean isValid() {
        if (this.imageData == null) {
            return false;
        }
        if (this.headerBitCount == BitCount.BI_BITCOUNT_1) {
            if (this.colorTable == null) {
                return false;
            }
            for (Color c : this.colorTable) {
                if (Color.BLACK.equals(c)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public InputStream getBMPStream() {
        return new ByteArrayInputStream(this.getBMPData());
    }

    public byte[] getBMPData() {
        if (this.imageData == null) {
            throw new RecordFormatException("bitmap not initialized ... need to call init() before");
        }
        int imageSize = (int)Math.max((long)this.imageData.length, (long)this.introSize + this.headerImageSize);
        byte[] buf = IOUtils.safelyAllocate((long)(14 + imageSize), (int)50000000);
        buf[0] = 66;
        buf[1] = 77;
        LittleEndian.putInt((byte[])buf, (int)2, (int)(14 + imageSize));
        LittleEndian.putInt((byte[])buf, (int)6, (int)0);
        LittleEndian.putInt((byte[])buf, (int)10, (int)(14 + this.introSize));
        System.arraycopy(this.imageData, 0, buf, 14, this.imageData.length);
        return buf;
    }

    public BufferedImage getImage() {
        try {
            return ImageIO.read(this.getBMPStream());
        }
        catch (IOException | RuntimeException e) {
            logger.log(7, new Object[]{"invalid bitmap data - returning placeholder image"});
            return this.getPlaceholder();
        }
    }

    public String toString() {
        return "{ headerSize: " + this.headerSize + ", width: " + this.headerWidth + ", height: " + this.headerHeight + ", planes: " + this.headerPlanes + ", bitCount: '" + (Object)((Object)this.headerBitCount) + "', compression: '" + (Object)((Object)this.headerCompression) + "', imageSize: " + this.headerImageSize + ", xPelsPerMeter: " + this.headerXPelsPerMeter + ", yPelsPerMeter: " + this.headerYPelsPerMeter + ", colorUsed: " + this.headerColorUsed + ", colorImportant: " + this.headerColorImportant + ", imageSize: " + (this.imageData == null ? 0 : this.imageData.length) + "}";
    }

    protected BufferedImage getPlaceholder() {
        BufferedImage bi = new BufferedImage(this.headerWidth, this.headerHeight, 2);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setComposite(AlphaComposite.Clear);
        g.fillRect(0, 0, this.headerWidth, this.headerHeight);
        int arcs = Math.min(this.headerWidth, this.headerHeight) / 7;
        Color bg = Color.LIGHT_GRAY;
        Color fg = Color.GRAY;
        LinearGradientPaint lgp = new LinearGradientPaint(0.0f, 0.0f, 5.0f, 5.0f, new float[]{0.0f, 0.1f, 0.1001f}, new Color[]{fg, fg, bg}, MultipleGradientPaint.CycleMethod.REFLECT);
        g.setComposite(AlphaComposite.SrcOver.derive(0.4f));
        g.setPaint(lgp);
        g.fillRoundRect(0, 0, this.headerWidth - 1, this.headerHeight - 1, arcs, arcs);
        g.setColor(Color.DARK_GRAY);
        g.setComposite(AlphaComposite.Src);
        g.setStroke(new BasicStroke(2.0f));
        g.drawRoundRect(0, 0, this.headerWidth - 1, this.headerHeight - 1, arcs, arcs);
        g.dispose();
        return bi;
    }

    public static enum Compression {
        BI_RGB(0),
        BI_RLE8(1),
        BI_RLE4(2),
        BI_BITFIELDS(3),
        BI_JPEG(4),
        BI_PNG(5),
        BI_CMYK(11),
        BI_CMYKRLE8(12),
        BI_CMYKRLE4(13);

        int flag;

        private Compression(int flag) {
            this.flag = flag;
        }

        static Compression valueOf(int flag) {
            for (Compression c : Compression.values()) {
                if (c.flag != flag) continue;
                return c;
            }
            return null;
        }
    }

    public static enum BitCount {
        BI_BITCOUNT_0(0),
        BI_BITCOUNT_1(1),
        BI_BITCOUNT_2(4),
        BI_BITCOUNT_3(8),
        BI_BITCOUNT_4(16),
        BI_BITCOUNT_5(24),
        BI_BITCOUNT_6(32);

        int flag;

        private BitCount(int flag) {
            this.flag = flag;
        }

        static BitCount valueOf(int flag) {
            for (BitCount bc : BitCount.values()) {
                if (bc.flag != flag) continue;
                return bc;
            }
            return null;
        }
    }
}

