/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.common.usermodel.fonts.FontFacet;
import org.apache.poi.common.usermodel.fonts.FontHeader;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public class FontEmbeddedData
extends RecordAtom
implements FontFacet {
    private static final int MAX_RECORD_LENGTH = 1000000;
    private byte[] _header;
    private byte[] _data;

    FontEmbeddedData() {
        this._header = new byte[8];
        this._data = new byte[4];
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    FontEmbeddedData(byte[] source, int start, int len) {
        this._header = Arrays.copyOfRange(source, start, start + 8);
        this._data = IOUtils.safelyClone((byte[])source, (int)(start + 8), (int)(len - 8), (int)1000000);
        if (this._data.length < 4) {
            throw new IllegalArgumentException("The length of the data for a ExObjListAtom must be at least 4 bytes, but was only " + this._data.length);
        }
    }

    @Override
    public long getRecordType() {
        return RecordTypes.FontEmbeddedData.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    public void setFontData(byte[] fontData) {
        this._data = (byte[])fontData.clone();
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    public FontHeader getFontHeader() {
        FontHeader h = new FontHeader();
        h.init(this._data, 0, this._data.length);
        return h;
    }

    public int getWeight() {
        return this.getFontHeader().getWeight();
    }

    public boolean isItalic() {
        return this.getFontHeader().isItalic();
    }

    public String getTypeface() {
        return this.getFontHeader().getFamilyName();
    }

    public Object getFontData() {
        return this;
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties((String)"fontHeader", this::getFontHeader);
    }
}

