/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.SkipException;

public class FailFastNotifier
implements IInvokedMethodListener,
ITestListener {
    private static final boolean FAIL_FAST_ENABLED = Boolean.parseBoolean(System.getProperty("testFailFast", "true"));

    public void onTestFailure(ITestResult result) {
        FailFastEventsSingleton.getInstance().setSkipOnNextTest();
        if (result.getThrowable() instanceof FailFastSkipException) {
            result.setThrowable(null);
            result.setStatus(3);
        }
    }

    public void beforeInvocation(IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
        if (FAIL_FAST_ENABLED && FailFastEventsSingleton.getInstance().isSkipAfterFailure()) {
            throw new FailFastSkipException("Skipped after failure since testFailFast system property is set.");
        }
    }

    public void afterInvocation(IInvokedMethod iInvokedMethod, ITestResult iTestResult) {
    }

    static class FailFastEventsSingleton {
        private static final FailFastEventsSingleton INSTANCE = new FailFastEventsSingleton();
        private volatile boolean skipAfterFailure;

        private FailFastEventsSingleton() {
        }

        public static FailFastEventsSingleton getInstance() {
            return INSTANCE;
        }

        public boolean isSkipAfterFailure() {
            return this.skipAfterFailure;
        }

        public void setSkipOnNextTest() {
            this.skipAfterFailure = true;
        }
    }

    static class FailFastSkipException
    extends SkipException {
        FailFastSkipException(String skipMessage) {
            super(skipMessage);
            this.reduceStackTrace();
        }
    }
}

