/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.pulsar.buildtools.shaded.org.apache.commons.lang3.ClassUtils;
import org.apache.pulsar.buildtools.shaded.org.apache.commons.lang3.ThreadUtils;
import org.apache.pulsar.buildtools.shaded.org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.pulsar.buildtools.shaded.org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.pulsar.tests.ThreadLocalStateCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FastThreadLocalStateCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(FastThreadLocalStateCleaner.class);
    private static final ThreadLocal<?> SLOW_THREAD_LOCAL_MAP = FastThreadLocalStateCleaner.lookupSlowThreadLocalMap();
    private static final Class<?> FAST_THREAD_LOCAL_CLASS;
    private static final Method GET_THREAD_LOCAL_MAP;
    private static final Field INDEXED_VARIABLES_FIELD;
    private static final Object UNSET_OBJECT;
    private final Predicate<Object> valueFilter;

    private static ThreadLocal<?> lookupSlowThreadLocalMap() {
        try {
            Field slowThreadLocalMapField = FieldUtils.getDeclaredField(ClassUtils.getClass("io.netty.util.internal.InternalThreadLocalMap"), "slowThreadLocalMap", true);
            if (slowThreadLocalMapField != null) {
                return (ThreadLocal)slowThreadLocalMapField.get(null);
            }
            LOG.warn("Cannot find InternalThreadLocalMap.slowThreadLocalMap field. This might be due to using an unsupported netty-common version.");
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            LOG.warn("Cannot find InternalThreadLocalMap.slowThreadLocalMap thread local", (Throwable)e);
            return null;
        }
    }

    public FastThreadLocalStateCleaner(Predicate<Object> valueFilter) {
        this.valueFilter = valueFilter;
    }

    public void cleanupAllFastThreadLocals(Thread thread, BiConsumer<Thread, Object> cleanedValueListener) {
        Objects.nonNull(thread);
        try {
            Object internalThreadLocalMap = FAST_THREAD_LOCAL_CLASS.isInstance(thread) ? GET_THREAD_LOCAL_MAP.invoke((Object)thread, new Object[0]) : ThreadLocalStateCleaner.INSTANCE.getThreadLocalValue(SLOW_THREAD_LOCAL_MAP, thread);
            if (internalThreadLocalMap != null) {
                Object[] indexedVariables = (Object[])INDEXED_VARIABLES_FIELD.get(internalThreadLocalMap);
                for (int i = 0; i < indexedVariables.length; ++i) {
                    Object threadLocalValue = indexedVariables[i];
                    if (threadLocalValue == UNSET_OBJECT || threadLocalValue == null || !this.valueFilter.test(threadLocalValue)) continue;
                    indexedVariables[i] = UNSET_OBJECT;
                    if (cleanedValueListener == null) continue;
                    cleanedValueListener.accept(thread, threadLocalValue);
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.warn("Cannot reset state for FastLocalThread {}", (Object)thread, (Object)e);
        }
    }

    public void cleanupAllFastThreadLocals(BiConsumer<Thread, Object> cleanedValueListener) {
        for (Thread thread : ThreadUtils.getAllThreads()) {
            this.cleanupAllFastThreadLocals(thread, cleanedValueListener);
        }
    }

    public static boolean isEnabled() {
        return SLOW_THREAD_LOCAL_MAP != null && FAST_THREAD_LOCAL_CLASS != null;
    }

    static {
        Class<?> clazz = null;
        Method getThreadLocalMapMethod = null;
        Field indexedVariablesField = null;
        Object unsetObject = null;
        if (SLOW_THREAD_LOCAL_MAP != null) {
            try {
                clazz = ClassUtils.getClass("io.netty.util.concurrent.FastThreadLocalThread");
                Class<?> internalThreadLocalMapClass = ClassUtils.getClass("io.netty.util.internal.InternalThreadLocalMap");
                getThreadLocalMapMethod = MethodUtils.getMatchingAccessibleMethod(clazz, "threadLocalMap", new Class[0]);
                indexedVariablesField = FieldUtils.getDeclaredField(internalThreadLocalMapClass, "indexedVariables", true);
                Field unsetField = FieldUtils.getField(internalThreadLocalMapClass, "UNSET");
                unsetObject = unsetField.get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException e) {
                LOG.debug("Ignoring exception", (Throwable)e);
                clazz = null;
                getThreadLocalMapMethod = null;
                indexedVariablesField = null;
                unsetObject = null;
            }
        }
        FAST_THREAD_LOCAL_CLASS = clazz;
        GET_THREAD_LOCAL_MAP = getThreadLocalMapMethod;
        INDEXED_VARIABLES_FIELD = indexedVariablesField;
        UNSET_OBJECT = unsetObject;
    }
}

