/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.tests;

import org.apache.pulsar.tests.BetweenTestClassesListenerAdapter;
import org.apache.pulsar.tests.MockitoThreadLocalStateCleaner;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockitoCleanupListener
extends BetweenTestClassesListenerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MockitoCleanupListener.class);
    private static final boolean MOCKITO_CLEANUP_ENABLED = Boolean.parseBoolean(System.getProperty("testMockitoCleanup", "true"));

    @Override
    protected void onBetweenTestClasses(Class<?> endedTestClass, Class<?> startedTestClass) {
        if (MOCKITO_CLEANUP_ENABLED) {
            if (MockitoThreadLocalStateCleaner.INSTANCE.isEnabled()) {
                LOG.info("Cleaning up Mockito's ThreadSafeMockingProgress.MOCKING_PROGRESS_PROVIDER thread local state.");
                MockitoThreadLocalStateCleaner.INSTANCE.cleanup();
            }
            this.cleanupMockitoInline();
        }
    }

    private void cleanupMockitoInline() {
        Mockito.framework().clearInlineMocks();
    }
}

